#!/bin/sh
set -e

: ${NDK64_PATH=$HOME/Android/Toolchains/ndk-arm/}
: ${NDK32_PATH=$HOME/Android/Toolchains/ndk-arm/}

# Only 64bit support
GCC64=$NDK64_PATH/bin/aarch64-linux-android29-clang
# GCC32=$NDK32_PATH/bin/arm-linux-androideabi-gcc

SYSROOT64=$NDK64_PATH/sysroot/
# SYSROOT32=$NDK32_PATH/sysroot/

SRCS="mali_poc.c"

$GCC64 -pie -fPIC --sysroot=$SYSROOT64 $SRCS -o mali_poc_64
echo "[+] mali_poc_64 compiled successfully."

# $GCC32 -pie -fPIC --sysroot=$SYSROOT32 $SRCS -o mali_poc_32
# echo "[+] mali_poc_32 compiled successfully."
