# CVE-2021-27965
Simple PoC for exploiting CVE-2021-27965 for LPE by spawning system cmd.

https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-27965

An issue was discovered in signed MICSYS windows driver (MsIo64.sys) which may lead to compromisation of whole local system. Driver's ioctl dispatch routine suffers from stack based buffer overflow in __all__ IOCTL codes and also lacks of validation of user supplied buffer.

## IOCTL
Anyone can create handle and issue ioctl requests to these ioctl codes which break windows security model:

- _0x80102040_ - arbitrary physical memory mapping into calling process and unchecked pointer access (possible system crash/DoS)
- _0x80102044_ - unmapping physical memory and unchecked pointer access (possible system crash/DoS)
- _0x80102050_ - arbitrary port read (byte, word, dword)
- _0x80102054_ - arbitrary port write (byte, word, dword)

## Stack Buffer Overflow
On each IOCTL code, driver is not accessing _Irp->SystemBuffer_ directly but rather using memcpy like function to copy _Irp->SystemBuffer_ into current function's stack frame buffer which has always fixed size (and then using this buffer). Since both _Irp->SystemBuffer_ and _Irp->CurrentStackLocation->InputBufferLength_ are controlled by calling process, a malicious actor could send large enough buffer to overflow the one inside function stack frame. To note: Even if in DriverEntry is **__security_init_cookie()**, in ioctl dispatch is **__security_check_cookie()** missing for some reason.

## Compiling PoC
TODO

## Tested on
TODO
