#!/bin/bash

echo "🔍 Scanning for insecure Random usage..."

FILE="src/main/java/InsecureTokenGenerator.java"

if grep -q "new Random()" "$FILE"; then
    echo "⚠️ Insecure Random detected. Fixing..."
    
    sed -i 's/import java.util.Random;/import java.security.SecureRandom;/g' "$FILE"
    sed -i 's/Random random = new Random();/SecureRandom secureRandom = new SecureRandom();/g' "$FILE"
    sed -i 's/random.nextInt/secureRandom.nextInt/g' "$FILE"

    mv "$FILE" src/main/java/SecureTokenGenerator.java
    echo "✅ File fixed and saved as SecureTokenGenerator.java"
else
    echo "✅ No vulnerable code found."
fi
  
