# SmmExploit

This is a report and an exploit of [CVE-2021-26943](https://cve.mitre.org/cgi-bin/cvename.cgi?name=2021-26943), the kernel-to-SMM local privilege escalation vulnerability in ASUS UX360CA BIOS version 303. The issue was fixed in the [version 304](https://www.asus.com/supportonly/UX360CA/HelpDesk_BIOS/).

# Issue Description

## Summary

UX360CA BIOS version 303 has 3 vulnerable modules that allow an attacker with the ring0 privilege to overwrite nearly arbitrary physical memory including SMRAM and execute arbitrary code in SMM.

Those modules can be identified as follows:

| Name    | GUID                                 | SHA256                                                           |
|---------|--------------------------------------|------------------------------------------------------------------|
| UsbRt   | 04EAAAA1-29A1-11D7-8838-00500473D4EB | 8A3DEAFD0A688DD4360A65C98E434180152EB43EB2C913C663F13D5709776781 |
| SdioSmm | EA343100-1A37-4239-A3CB-B92240B935CF | 4578E1E147D846BB925DF881A2A0A3C3F1E6CD2AE033A8B0F769E5EB42783A0A |
| NvmeSmm | E5E2C9D9-5BF5-497E-8860-94F81A09ADE0 | A9C762B13FC9C4156603D674C6DAEBC4369520D95ACB1D0FA976078D6F7F1003 |

Those modules are from AMI (BIOS vendor) and may present in other OEM's BIOS.

## Vulnerabilities

The vulnerable modules and corresponding SMIs are: UsbRt (0x31), SdioSmm (0x40), and NvmeSmm (0x42). All of those SMI handlers read physical memory address 0x40E to get an address to work on and write one byte to the address in case of error, even if it is SMRAM.

For example, SdioSmm's SMI handler looks as follows:
```cpp
EFI_STATUS
EFIAPI
SdioSmm_SwSmi_40h(
  EFI_HANDLE  DispatchHandle,
  CONST VOID  *Context,
  VOID        *CommBuffer,
  UINTN       *CommBufferSize
  )
{
  // ...
  struct_v0 *userControlled = *(0x10 * MEMORY[0x40E] + 0x104);
  if ( EFI_ERROR(ValidateBufferIsOutsideSmram(userControlled, sizeof(struct_v0)))
    || userControlled->Offset0_FunctionCode >= 4 )
  {
    userControlled->Offset2 = 7;
  }
  else
  {
    // ...
  }
  return EFI_SUCCESS;
}
```

This issue appears to be identical with INTEL-SA-00057, which is greatly described as [Aptiocalypsis](https://github.com/Cr4sh/Aptiocalypsis). The BIOS version 303 for UX360CA, however, does not include fixes for them.

## Exploitation

This allows an attacker with write access to physical memory and the OUT instruction (ie, the ring0 privileges) to overwrite contents of SMRAM with the following steps:
1. Make sure physical address 0x40e is zero (which is most likely the case already)
2. Write an address of SMRAM, say 0x88400000, at physical address 0x104
3. Issue the SMI 0x40
4. 0x88400000+2 is updated with 0x7.

This can be used to achieve arbitrary code execution in SMM as follows:
1. Find the address of the System Management Service Table (SMST) in SMRAM, with the below steps:
    1. Get a physical address range for UEFI runtime code from the contents of the `.Raw` value in `HKLM\HARDWARE\RESOURCEMAP\System Resources\Loader Reserved`
    2. Find the address of SMM_CORE_PRIVATE_DATA by scanning the 'smmc' signature from the address range.
    3. SMM_CORE_PRIVATE_DATA has the pointer to the SMST at offset 30h
2. Overwrite the pointer to the SmmLocateProtocol function at offset d0h of the SMST using the above write primitive. The value is updated to 0x07070707.
3. Write shellcode at physical memory 0x07070707
4. Trigger another SMI that calls the Smst->SmmLocateProtocol, such as SMI 0xdf. The shellcode at 0x07070707 is executed in SMM.

Arbitrary code execution in SMM would let an attacker bypass security measures by kernel and hypervisor such as HVCI as demonstrated in [another SMM vulnerability report](https://dannyodler.medium.com/attacking-the-golden-ring-on-amd-mini-pc-b7bfb217b437) and establish persistence by updating contents of the SPI flash (BIOS).

## Proof of Concept (PoC)

The attached demo project demonstrates successful exploitation and dumps contents of MSRs that are only accessible in SMM and the physical address of the EPTP. It also modifies Hyper-V hypervisor's CPUID VM-exit handling code to return an altered hypervisor vendor string.

The PoC is tested on Windows build 18362.1256, with and without HVCI enabled.

Recoding of successful exploitation can be found at [YouTube](https://youtu.be/jZWzBF8LKzM).
![Demo.png](Demo.png)

### Test Instructions

1. Open the demo.sln in Visual Studio 2019
2. Build the solution for Debug or Release build
3. Copy the compiled demo.sys into the target system (say, C:\users\user\desktop\demo.sys)

On the target system,
1. Disable secure boot from BIOS, and reboot
2. Enable the test signing mode, and reboot
    ```
    > bcdedit /set testsigning on
    ```
3. Create the service to load the demo.sys
    ```
    > sc create demo type= kernel binPath= C:\users\user\desktop\demo.sys
    ```
4. Start [DebugView](https://docs.microsoft.com/en-us/sysinternals/downloads/debugview) and enable "Capture Kernel" from the "Capture" menu.
5. Start the demo
    ```
    > sc start demo
    ```
6. If successful, DebugView will show values of SMM related MSRs.
    ```
    [+] ReportSmramRange: TSEG implied SMRAM: 0x88400000 - 0x88800000
    [-] ReportSmramRange: Exception occurred while accessing SMRR MSR : c0000096
    [+] FindSystemManagementServiceTable: SMM core found at 0x87f1b390 in RT Code
    [+] FindSystemManagementServiceTable: SMST found at 0x887fa710 in SMRAM
    [+] ExploitSmm: Patched SMST->SmmLocateProtocol in SMRAM
    [+] ExploitSmm: Placed SMM shell code
    [+] ExploitSmm: Triggered SMM exploit
    [+] DumpSmmExploitOuput: IA32_SMBASE             = 0x887cd000
    [+] DumpSmmExploitOuput: MSR_SMM_FEATURE_CONTROL = 0x1
    [+] DumpSmmExploitOuput: MSR_SMM_MCA_CAP         = 0xc00000000000000
    [+] DumpSmmExploitOuput: EPT pointer             = 0x10a72001e
    [+] DumpSmmExploitOuput: Patched Hv address      = 0x1004382f0
    [+] ExploitSmm: Successfully executed shell code in SMM. Failing DriverEntry to unload itself
    DriverEntry failed 0xc0000120 for driver \REGISTRY\MACHINE\SYSTEM\ControlSet001\Services\demo
    ```
7. If Hyper-V is running and code modification was successful, CPUID 0x4000000 will return the modified hypervisor vendor string `Hv Tampered!`.
    ```
    > CheckHvVendor.exe
    Executing CPUID(0x40000000) on CPU 0
    Result: Hv Tampered!
    Executing CPUID(0x40000000) on CPU 1
    Result: Hv Tampered!
    Executing CPUID(0x40000000) on CPU 2
    Result: Hv Tampered!
    Executing CPUID(0x40000000) on CPU 3
    Result: Hv Tampered!
    ```

# Resolution

The fix is to avoid using the user-controlled contents at all when it points inside SMRAM, as shown below.

```cpp
{
  // ...
  struct_v0 *userControlled = *(0x10 * MEMORY[0x40E] + 0x104);
  if (!EFI_ERROR(ValidateBufferIsOutsideSmram(userControlled, sizeof(struct_v0))))
  {
    if (userControlled->Offset0_FunctionCode < 7 )
    {
      // ...
    }
    else
    {
      userControlled->Offset2 = 7;
    }
  }
  return EFI_SUCCESS;
}
```

## Considerations

### Missing protection for hypervisor

The fix perfectly follows the current industry best practice and prevents the confused deputy attack that leads to SMRAM corruption.

Notice that it does not take account of hypervisor memory regions, however. An attacker with knowledge of the physical memory address where the hypervisor is loaded or uses could still request the SMI to overwrite hypervisor code or data and achieve the hypervisor corruption.

This is a prevalent, long-existed, and even design-level issue.

### Lack of defense-in-depth

The reported issues were resolved, but there were some problems in terms of exercising the defense-in-depth strategy.

For example, the SMM page table is identity-mapping with full readable, writable, and executable permissions, and the `SMM_Code_Chk_En` feature was unavailable. Those made exploitation trivial. I also notice SMM communication buffer is not verified with `SmmIsBufferOutsideSmmValid()` [as found in EDK2](https://github.com/tianocore/edk2/blob/stable/202011/MdeModulePkg/Core/PiSmmCore/PiSmmCore.c#L701), although I did not find an exploitable SMI.

I believe those are common issues across OEMs and many BIOS versions. I call out that if you are on old models from any OEMs, that BIOS is unlikely as secure as you might wish even with their latest BIOS versions.

### Improvements

Those problems will not go away anytime very soon, but I am excited to see that the industry is working on an architectural resolution by reducing the SMM privileges. Here is some of those work and articles you can check out:
- Platform Runtime Mechanism (PRM)
    - [Presentation (Open-Source Firmware Conference 2020)](https://cfp.osfc.io/osfc2020/talk/MCJASB/)
    - [Specification (uefi.org)](https://uefi.org/sites/default/files/resources/Platform%20Runtime%20Mechanism%20-%20with%20legal%20notice.pdf)
    - [Implementation (edk2-staging)](https://github.com/tianocore/edk2-staging/tree/PlatformRuntimeMechanism)
- [System Management Mode deep dive: How SMM isolation hardens the platform](
https://www.microsoft.com/security/blog/2020/11/12/system-management-mode-deep-dive-how-smm-isolation-hardens-the-platform/)
- [System requirements for System Guard](https://docs.microsoft.com/en-us/windows/security/threat-protection/windows-defender-system-guard/system-guard-secure-launch-and-smm-protection#system-requirements-for-system-guard)

## Timeline

Here is some highlights.
- 2020-12-31 - I reported the vulnerability
- 2021-01-05 - ASUS acknowledged the report
- 2021-01-18 - ASUS sent me the fixed version of BIOS for testing
- 2021-01-20 - I confirmed the fix and replied back
- 2021-01-25 - ASUS acknowledged my reply
- 2021-03-21 - ASUS publicized the fix, [version 304](https://www.asus.com/supportonly/UX360CA/HelpDesk_BIOS/)
- 2021-03-29 - ASUS issued an [advisory entry](https://www.asus.com/content/ASUS-Product-Security-Advisory/) for CVE-2021-26943

Finally, big thanks to the ASUS teams for keeping the communication loop close and transparent❤ The overall process was not fast but rather frustration-free.
