# CS-Cart templates.manage Server Side Template Injection Remote Code Execution Vulnerability

Found by: Steven Seeley of 360 Vulcan Team  
Version: <= 4.12.x (latest)  
Date: 2021-01-08 12:49  
CVE: CVE-2021-26121  

# Disclosure Timeline

- 2021-01-26 – Sent to CSCart dev team
- 2021-01-27 – Notification of reciept from CSCart dev team
- 2021-02-10 – Response from CSCart as not a security bug
- 2021-02-12 – Public disclosure

# Summary

A shop admin (not to be confused with a root admin) can gain remote code execution via server-side Smarty template injection when editing templates. This is due to the fact that CSCart doesn't implement the Smarty sandbox as described in the documentation https://www.smarty.net/docs/en/advanced.features.tpl#advanced.features.security. 

# Notes

This is not normally a huge concern but on CSCart it means that a shop admin can get access to other shop admins data (and the underlying OS). I imagine you do consider this security boundary, which is why you patched CVE-2017-15673.

# Proof of Concept

When logged in as a Shop admin you can edit any of the templates. In this case I edited the `my_account.tpl` template file adding `{phpinfo()}`

![](images/fdaf961b7930495590a332aa1259ce78.png)

Then, after viewing the index page and clicking the my account drop down menu, it's possible to trigger the template execution:

![](images/6f34195ad5d94050a6f2c40289dd91ef.png)

It's also possible to trigger this vulnerability if the shop admin has just `Files` access via group assignment with no other permission.

![](images/03f11c18ad744284895519686ae7b07b.png)

And here is the vulnerability impacting the `https://[redacted]/` demo site:

![](images/94e40c2037a54db3a831c195ccdd3a7a.png)
