[![Open in GitHub Codespaces](https://github.com/codespaces/badge.svg)](https://github.com/codespaces/new?repo=hackmelocal/CVE-2021-24891-Simulation)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)

A hands-on, containerized lab environment to simulate and exploit a DOM-based Cross-Site Scripting (XSS) vulnerability in the Elementor Website Builder WordPress plugin, identified as `CVE-2021-24891`.

## 📖 About The Vulnerability

This lab demonstrates a **DOM-based Cross-Site Scripting (XSS)** vulnerability in the Elementor plugin for WordPress (versions prior to 3.4.8). The vulnerability occurs because the Elementor editor's client-side code directly reads data from the URL's hash (`#...`) and appends it to the page's Document Object Model (DOM) without proper sanitization.

An attacker can craft a malicious link containing a JavaScript payload in the hash fragment. When a logged-in administrator (like a site editor) clicks this link, the malicious script executes within the context of their browser session, potentially allowing the attacker to perform actions on their behalf, steal session cookies, or deface the website.

### Key Concepts
- **DOM-based XSS:** A type of XSS attack where the payload is executed as a result of the web page's client-side script modifying the DOM in an insecure way.
- **URL Hash (Fragment Identifier):** The part of a URL beginning with a `#`, which is processed client-side and is not sent to the server. This is the entry point for the malicious payload.
- **Lack of Input Sanitization:** The root cause of the vulnerability. The application's JavaScript trusts user-controllable input from the URL hash and uses it to construct HTML, leading to script execution.

---

## 🎯 Live Simulation Lab

This repository contains a vulnerable WordPress instance with the affected Elementor plugin, ready for you to exploit. The lab can be run instantly in the cloud or on your local machine.

### Method 1: Run in GitHub Codespaces (Recommended)

This is the easiest way to get started. It provides a pre-configured, cloud-based environment in your browser.

1.  **Launch Codespace:** Click the "Open in GitHub Codespaces" badge at the top of this README.
    [![Open in GitHub Codespaces](https://github.com/codespaces/badge.svg)](https://github.com/codespaces/new?repo=hackmelocal/CVE-2021-24891-Simulation)

2.  **Wait for Setup:** GitHub will prepare your environment. Once complete, a terminal will appear.

3.  **Start the Vulnerable Services:** In the VS Code terminal, run the following single command:
    ```bash
    docker compose up
    ```
    This will start the vulnerable WordPress site and its database. You will see a "Ports" tab appear. Click the link for Port `8080` to open WordPress in a new browser tab.

### Method 2: Run Locally

Run the entire lab on your own machine with Docker.

**Prerequisites:**
- [Docker](https://docs.docker.com/get-docker/) installed.
- [Docker Compose](https://docs.docker.com/compose/install/) installed.

**Instructions:**
1.  **Clone the Repository:**
    ```bash
    git clone https://github.com/hackmelocal/CVE-2021-24891-Simulation.git
    cd CVE-2021-24891-Simulation
    ```

2.  **Start the Vulnerable Services:** In your terminal, run the command:
    ```bash
    docker compose up
    ```

3.  **Access WordPress:** Open your web browser and navigate to `http://localhost:8080`.

---

### What's Happening?

The JavaScript code within the Elementor editor reads the value from `window.location.hash` and insecurely writes it to the page's DOM. Because the input (`<script>alert(...)</script>`) is not sanitized, the browser interprets it as a valid script tag and executes it. This is a classic example of DOM-based XSS.

## ⚠️ Disclaimer

This lab is provided for educational purposes only. The creator is not responsible for any misuse of the information or tools provided. Always ensure you have proper authorization before performing any security testing.

## 📄 License

This project is licensed under the MIT License. See the [LICENSE](LICENSE) file for details.
