# CVE-2021-24006 – FortiManager Improper Access Control Exploit (PoC)

**PoC (Proof of Concept) - Educational Use Only**  
Exploit de acesso indevido ao SD-WAN Orchestrator em FortiManager, explorando falha de controle de acesso (CWE-284).

---

## Descrição

A vulnerabilidade **CVE-2021-24006** afeta o FortiManager (versões 6.4.0 até 6.4.3) e permite que **usuários autenticados com perfil restrito** acessem diretamente a URL do painel do **SD-WAN Orchestrator**, mesmo sem permissão explícita via interface.

> Acesso direto à URL vulnerável:  
> `https://<IP>/fortiwan/maintenance/controller_configuration`

---

## Atinge

- FortiManager **6.4.0 até 6.4.3**
- **FortiManager 6.2.x e anteriores não são afetados**

---

## Pré-requisitos

- FortiManager com SD-WAN Orchestrator instalado
- Usuário com perfil **Restricted Admin**
- Acesso à interface Web do FortiManager

---

## Exploração (educacional)

1. Autenticar na interface Web com um usuário de perfil restrito  
2. Visitar diretamente a URL:

## Mitigações

- Atualizar para **FortiManager 6.4.4 ou superior**
- Alternativamente, utilizar **versão 7.0.0+**
- Restringir o acesso à interface Web por IP
- Monitorar logs de requisições à URL crítica

---

## Aviso Legal

> Este código é fornecido **apenas para fins educacionais e de conscientização**.  
> Não execute em ambientes de produção ou sem autorização explícita.

---

## Tags

`CVE-2021-24006` `fortinet` `fortimanager` `sd-wan` `exploit` `poc` `vulnerability` `access-control` `bypass`
