# CVE-2021-21341 XStream DoS

## XStream Official Announcement

[CVE-2021-21341](https://x-stream.github.io/CVE-2021-21341.html)

**Vulnerability**

CVE-2021-21341: XStream can cause a Denial of Service.

**Affected Versions**

All versions until and including version 1.4.15 are affected, if using the version out of the box. No user is affected, who followed the recommendation to setup XStream's security framework with a whitelist limited to the minimal required types.

**Description**

The processed stream at unmarshalling time contains type information to recreate the formerly written objects. XStream creates therefore new instances based on these type information. An attacker can manipulate the processed input stream and replace or inject a manipulated ByteArrayInputStream (or derived class), that can cause an endless loop resulting in a denial of service.

## Docker Demo

![cve-2021-21341](https://user-images.githubusercontent.com/56715563/116986789-31fe6a80-ad09-11eb-8d97-d15702601606.gif)

## Set Up XStream Environment & PoC Execution

1. Build an image from a Dockerfile (Set Up)

```
$ docker build -t cve-2021-21341 .
```

2. Run java -jar xstream in a new container (PoC Execution)

```
$ docker run -it --rm cve-2021-21341
```

## Output

```
Security framework of XStream not explicitly initialized, using predefined black list on your own risk.

(never end)
```

## Solution

- Update xstream version to 1.4.16 or higher

Change pom.xml to bellow

```
        <dependency>
            <groupId>com.thoughtworks.xstream</groupId>
            <artifactId>xstream</artifactId>
            <version>1.4.16</version>
        </dependency>
```

- Use XStream's security framework

Add NoTypePermission.NONE

```
import com.thoughtworks.xstream.security.NoTypePermission; // Add

XStream xstream = new XStream();
xstream.addPermission(NoTypePermission.NONE); // Add
xstream.fromXML(xml);
```
