# CVE-2020-8158: TypeORM Prototype Pollution Vulnerability

## Overview
This is a proof-of-concept demonstrating CVE-2020-8158, a critical prototype pollution vulnerability in TypeORM versions < 0.2.25.

## Vulnerability Details
- **CVE ID**: CVE-2020-8158
- **CVSS Score**: 9.8 (CRITICAL)
- **Affected Package**: TypeORM < 0.2.25
- **Vulnerability Type**: Prototype Pollution (CWE-1321)
- **HackerOne Report**: https://hackerone.com/reports/869574

## Impact
Attackers can:
1. Add or modify Object prototype properties
2. Trigger denial of service
3. Inject SQL payloads
4. Bypass authentication/authorization
5. Execute arbitrary code

## Root Cause
The vulnerability exists in TypeORM's handling of object deserialization when processing database query results. The library improperly merges user-controlled data into objects without sanitizing prototype-polluting keys like `__proto__`, `constructor`, and `prototype`.

## Affected Code Path
The issue is in the entity hydration/deserialization process where TypeORM recursively assigns properties from raw query results to entity objects without proper validation.

## Files in This PoC
- `vulnerable-app.ts` - Vulnerable TypeORM application (version < 0.2.25)
- `exploit.ts` - Proof-of-concept exploit
- `patched-app.ts` - Patched version (version >= 0.2.25)
- `package.json` - Dependencies

## Setup Instructions
See `SETUP.md` for detailed setup and exploitation instructions.

## Mitigation
- Upgrade TypeORM to version 0.2.25 or later
- Validate and sanitize all user inputs
- Use input validation libraries to block prototype pollution attempts
- Consider using Object.freeze() on critical objects

## References
- Official TypeORM Security Advisory
- OWASP Prototype Pollution
- CWE-1321: Improperly Controlled Modification of Object Prototype Attributes
