# sagex3-cve-2020-7388-poc
Proof of concept exploit code for CVE-2020-7388, an unauthenticated RCE as SYSTEM on Sage X3's AdxDSrv Service

## Overview
Sage X3 exposes an administrative service on port TCP/1818 (default, but changeable) under the process "AdxDSrv.exe," part of the AdxAdmin component. This service is used for remote administration of the Sage ERP solution through the Sage X3 Console. A vulnerability within the service allows a malicious actor to craft a request to the exposed service to execute commands on the server as the "NT AUTHORITY/SYSTEM" user.

Detailed exploit write-up can be found from our original publication on Rapid7's blog: https://www.rapid7.com/blog/post/2021/07/07/cve-2020-7387-7390-multiple-sage-x3-vulnerabilities/

## Exploit details
AdxDSrv runs on TCP port 1818 by default, and is listed as an unknown service in Namp. This repository contains two NSE scripts to identify vulnerable services and the AdxdSrv itself.

`python3 adxsrv_bypass.py --cmd <command to run as SYSTEM> --ip <remote target> --port <port of AdxDSrv service>`


### Crude PoC warning
Note: this is a rough PoC, sending byte-streams in specific order, and might need adjustments made. Our limitied time with access to the software prevented fine-tuning the exploits. If you encounter a vulnerable instance and fix up the PoC, please submit a PR! Or if you're trying to fix it up and want to collaborate, feel free to reach out.


## Credits
During a network penetration test in 2020, Cale Black identified new vulnerabilities in the web admin panel of Sage's X3 ERP. This prompted further investigation into the application between Jonathan peterson (@deadjakk), Aaron Herndon (@ac3lives), Cale Black, Ryan Villarreal (@XjCrazy09) and William Vu. We dove in and identified the AdxDSrv custom Sage X3 service, which was used for remote administration. After some reversing and fuzzing, we landed with four CVEs, one being a CVSS10 unauth remote code exec. Major shoutout to the heavy weight lifter here, @Deadjakk, for a lot of the reversing and initial PoC mockups.
