# CVE-2020-36842


# CVE-2020-36842 - WPvivid Plugin Arbitrary File Upload Vulnerability

## Overview
- **CVE ID:** CVE-2020-36842
- **Disclosure / Update Date:** October 16, 2024
- **Affected Plugin:** WPvivid - Migration, Backup, Staging
- **Affected Versions:** Up to and including **0.9.35**
- **Vulnerability Type:** Arbitrary File Upload & Extraction
- **Required Privileges:** Authenticated User (Subscriber+)

## Description
The **WPvivid** WordPress plugin, designed for site migration and backups, is vulnerable to an arbitrary file upload flaw. This vulnerability allows authenticated users with low-level privileges to upload and extract **ZIP** files, potentially leading to remote code execution (RCE) if a malicious script is deployed within the extracted files.

## Exploitation Process
A **Python** exploit script has been crafted to take advantage of this vulnerability using the following methodology:

1. **Version Check:** Determines if the target WordPress site is running **v0.9.35** or lower.
2. **Authentication:** Logs in using provided WordPress credentials.
3. **File Upload:** Searches for a **ZIP** file in the current directory and uploads it via WPvivid's **AJAX API**.
4. **Upload Confirmation:** Verifies that the file was successfully uploaded.
5. **Extraction Trigger:** Executes the WPvivid import function to extract the uploaded archive.
6. **Shell Deployment Check:** Confirms if a malicious script (e.g., **nxploit.php**) is successfully deployed and accessible.

## Expected Output
If the exploitation is successful, the script will output:
```
[+] Logged in successfully.
[+] Target is vulnerable. Proceeding with exploitation.
[+] Uploading file: Success
[+] Confirming upload: Success
[+] Starting import: Success
[+] Shell uploaded successfully at: http://target-site.com/wp-content/nxploit.php
```
## How to Use the Exploit
### Prerequisites

Ensure that a malicious shell.zip file exists in the same directory as the exploit script.

The shell.zip file should contain a PHP web shell `(e.g., nxploit.php).`

A valid WordPress account with Subscriber or higher privileges is required.
### Execution Steps
1. Run the exploit script with the following command:
```
python CVE-2020-36842.py -u http://target-site.com -un username khaled -p password 123
```
2. The script will check the target version and log in using the provided credentials.

3. If the target is vulnerable, the script will upload shell.zip and extract it.

4. If successful, the script will provide a URL to the uploaded shell.

### Interacting with the Web Shell

Once the shell is successfully uploaded and extracted, you can interact with it by sending commands via a URL:
```
http://target-site.com/wp-content/nxploit.php?cmd=pwd
```


## Mitigation Strategies
To mitigate this vulnerability, it is strongly recommended to:
1. **Update the WPvivid plugin** to the latest secure version.
2. **Restrict user roles** to prevent unauthorized file uploads.
3. **Monitor server logs and file activity** to detect suspicious uploads.
4. **Disable direct script execution** in the `wp-content/uploads` directory using `.htaccess` or server configurations.

## Conclusion
This vulnerability presents a serious risk as it enables authenticated attackers to upload and execute malicious files on a WordPress server. Site administrators should take immediate action to secure their installations.

**Disclaimer:** This document is intended for ethical security research and educational purposes only. Exploiting vulnerabilities without permission is illegal and punishable under applicable laws. ( Nxploit | Khaled_alenazi )
