# CVE-2020-36708 – WordPress Epsilon Framework Function Injection PoC

## Overview
**CVE-2020-36708** is a vulnerability in the **Epsilon Framework** for WordPress that allows unauthenticated attackers to invoke arbitrary PHP class methods via the AJAX action `epsilon_framework_ajax_action`.  

This issue is categorized as a **function injection vulnerability** because an attacker controls both:
- The **class** to call (e.g., `Requests`)
- The **method** to invoke (e.g., `request_multiple`)
- The **arguments** to supply

In effect, the attacker can direct the framework to execute PHP functions or library calls not intended to be exposed.  

The most straightforward and non-destructive way to demonstrate this is by abusing the bundled `Requests` library to trigger an **SSRF** (Server-Side Request Forgery). By forcing the server to make a web request to a controlled domain, we confirm arbitrary function execution without impacting the target system.

If Burp pro isn't available use webhook.site in it's place.


This PoC is for educational and authorized penetration testing only.
Do not use it against systems without explicit permission.
