🧨 CVE‑2020‑35848 – Cockpit CMS < 0.11.2 NoSQL Injection (RCE) Lab
CVE‑2020‑35848 affects Agentejo Cockpit CMS versions before 0.11.2, introducing a critical NoSQL injection vulnerability in the /auth/newpassword endpoint. This flaw allows unauthenticated attackers to inject MongoDB operators into password-reset requests, enabling them to:

Enumerate valid usernames

Extract password-reset tokens

Reset passwords for arbitrary accounts

Chain into remote code execution via file uploads or custom admin actions 
Check Point Software
+11
NVD
+11
GitHub
+11
FortiGuard Labs
+2
Exploit Database
+2
GitHub
+2
Feedly
+1
GitHub
+1

📊 NVD Severity Metrics
CVSS v3.1 Score: 9.8 (Critical) — network exploit, no privileges or user interaction required, high impacts on confidentiality, integrity, availability 
NVD
+1
NVD
+1

CWE-89: NoSQL Injection (Improper neutralization of special elements—commands injected into database queries) 
Check Point Software
+10
NVD
+10
CVE Details
+10

🧪 Lab Features
Dockerized vulnerable instance of Cockpit CMS v0.11.1

Simulates user enumeration, token exfiltration, and password reset flows

Contains pre-built scripts (e.g., automated_exploit.sh) to demonstrate full exploitation path:

Username enumeration via injection in /auth/requestreset

Token extraction using /auth/newpassword

Password reset via /auth/resetpassword

Admin login & web flag retrieval

(Optional) RCE via admin-accessible upload or webhook endpoints

Challenges extend to manual privilege escalation to uncover system flags
