
<div align="center">
  <img src="https://blogs.cappriciosec.com/uploaders/CVE-2020-35489.png" alt="logo">
</div>


## Badges



[![MIT License](https://img.shields.io/badge/License-MIT-green.svg)](https://choosealicense.com/licenses/mit/)
![PyPI - Version](https://img.shields.io/pypi/v/CVE-2020-35489)
![PyPI - Downloads](https://img.shields.io/pypi/dm/CVE-2020-35489)
![GitHub all releases](https://img.shields.io/github/downloads/Cappricio-Securities/CVE-2020-35489/total)
<a href="https://github.com/Cappricio-Securities/CVE-2020-35489/releases/"><img src="https://img.shields.io/github/release/Cappricio-Securities/CVE-2020-35489"></a>![Profile_view](https://komarev.com/ghpvc/?username=Cappricio-Securities&label=Profile%20views&color=0e75b6&style=flat)
[![Follow Twitter](https://img.shields.io/twitter/follow/cappricio_sec?style=social)](https://twitter.com/cappricio_sec)
<p align="center">

<p align="center">







## License

[MIT](https://choosealicense.com/licenses/mit/)



## Installation 

1. Install Python3 and pip [Instructions Here](https://www.python.org/downloads/) (If you can't figure this out, you shouldn't really be using this)

   - Install via pip
     - ```bash
          pip install CVE-2020-35489 
        ```
   - Run bellow command to check
     - `CVE-2020-35489 -h`

## Configurations 
2. We integrated with the Telegram API to receive instant notifications for vulnerability detection.
   
   - Telegram Notification
     - ```bash
          CVE-2020-35489 --chatid <YourTelegramChatID>
        ```
   - Open your telegram and search for [`@CappricioSecuritiesTools_bot`](https://web.telegram.org/k/#@CappricioSecuritiesTools_bot) and click start

## Usages 
3. This tool has multiple use cases.
   
   - To Check Single URL
     - ```bash
          CVE-2020-35489 -u http://example.com 
        ```
   - To Check List of URL 
      - ```bash
          CVE-2020-35489 -i urls.txt 
        ```
   - Save output into TXT file
      - ```bash
          CVE-2020-35489 -i urls.txt -o out.txt
        ```
   - Want to Learn about [`CVE-2020-35489`](https://blogs.cappriciosec.com/cve/154/Contact%20Form%207-%20When%20File%20Uploads%20Become%20a%20Security%20Nightmare%20(CVE-2020-35489))? Then Type Below command
      - ```bash
          CVE-2020-35489 -b
        ```
     
<p align="center">
  <b>🚨 Disclaimer</b>
  
</p>
<p align="center">
<b>This tool is created for security bug identification and assistance; Cappricio Securities is not liable for any illegal use. 
  Use responsibly within legal and ethical boundaries. 🔐🛡️</b></p>


## Working PoC Video

[![asciicast](https://blogs.cappriciosec.com/uploaders/Screenshot%202024-05-21%20at%202.33.56%20PM.png)](https://asciinema.org/a/vtjuKMZxVoDk0URvBtgD3nNG1)




## Help menu

#### Get all items

```bash
👋 Hey Hacker
                                                                            v1.0
   _______    ________    ___   ____ ___   ____       _____ ________ __  ____  ____
  / ____/ |  / / ____/   |__ \ / __ \__ \ / __ \     |__  // ____/ // / ( __ )/ __ \
 / /    | | / / __/________/ // / / /_/ // / / /_____ /_ </___ \/ // /_/ __  / /_/ /
/ /___  | |/ / /__/_____/ __// /_/ / __// /_/ /_____/__/ /___/ /__  __/ /_/ /\__, /
\____/  |___/_____/    /____/\____/____/\____/     /____/_____/  /_/  \____//____/

                              Developed By https://cappriciosec.com





CVE-2020-35489 : Bug scanner for WebPentesters and Bugbounty Hunters 

$ CVE-2020-35489 [option]

Usage: CVE-2020-35489 [options]
```


| Argument | Type     | Description                | Examples |
| :-------- | :------- | :------------------------- | :------------------------- |
| `-u` | `--url` | URL to scan | CVE-2020-35489 -u https://target.com |
| `-i` | `--input` | filename Read input from txt  | CVE-2020-35489 -i target.txt | 
| `-o` | `--output` | filename Write output in txt file | CVE-2020-35489 -i target.txt -o output.txt |
| `-c` | `--chatid` | Creating Telegram Notification | CVE-2020-35489 --chatid yourid |
| `-b` | `--blog` | To Read about CVE-2020-35489 Bug | CVE-2020-35489 -b |
| `-h` | `--help` | Help Menu | CVE-2020-35489 -h |



## 🔗 Links
[![Website](https://img.shields.io/badge/my_portfolio-000?style=for-the-badge&logo=ko-fi&logoColor=white)](https://cappriciosec.com/)
[![linkedin](https://img.shields.io/badge/linkedin-0A66C2?style=for-the-badge&logo=linkedin&logoColor=white)](https://www.linkedin.com/in/karthikeyan--v/)
[![twitter](https://img.shields.io/badge/twitter-1DA1F2?style=for-the-badge&logo=twitter&logoColor=white)](https://twitter.com/karthithehacker)



## Author

- [@karthithehacker](https://github.com/karthi-the-hacker/)



## Feedback

If you have any feedback, please reach out to us at contact@karthithehacker.com
