import requests

def check_for_datatables(url, proxy=None):
    headers = {
        'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36'
    }
    
    proxies = None
    if proxy:
        proxies = {
            'http': proxy,
            'https': proxy
        }
    
    try:
        response = requests.get(url, headers=headers, proxies=proxies, timeout=10)
        if 'datatables' in response.text:
            print("[+] DataTables found in the HTML.")
        else:
            print("[-] DataTables not found in the HTML.")
        
        # Optionally check known endpoints
        endpoints = ['/api/data', '/data', '/datatable']
        for endpoint in endpoints:
            res = requests.get(url + endpoint, headers=headers, proxies=proxies, timeout=10)
            if res.status_code == 200:
                print(f"[+] Found DataTables endpoint: {url + endpoint}")
    except requests.RequestException as e:
        print(f"[!] Error connecting to {url}: {e}")

if __name__ == "__main__":
    target_url = input("Enter the target URL (e.g., http://example.com): ")
    proxy_url = input("Enter proxy URL (leave blank if none): ").strip()
    proxy = proxy_url if proxy_url else None
    check_for_datatables(target_url, proxy)
