<?php
interface WC_Log_Handler_Interface {
	public function handle( $timestamp, $level, $message, $context );
}

abstract class WC_Log_Handler implements WC_Log_Handler_Interface {

}

class WC_Log_Handler_File extends WC_Log_Handler {
	protected $handles = array();

	/* Edited version of __construct() */
	public function __construct( $handles = array() ) {
		$this->handles = $handles;
	}

	public function __destruct() {
		foreach ( $this->handles as $handle ) {
			if ( is_resource( $handle ) ) {
				fclose( $handle ); // @codingStandardsIgnoreLine.
			}
		}
	}
	public function handle( $timestamp, $level, $message, $context ) {

	}
}

class Requests_Utility_FilteredIterator extends ArrayIterator {

	protected $callback;

	public function __construct($data, $callback) {
		parent::__construct($data);

		$this->callback = $callback;
	}

	public function current() {
		$value = parent::current();
		$value = call_user_func($this->callback, $value);
		return $value;
	}
}

$object_1 = new Requests_Utility_FilteredIterator(array('id'), 'system');

$object_2 = new WC_Log_Handler_File($object_1);

print_r($object_2);

