# WP-file-manager expoit [CVE-2020-25213](https://nvd.nist.gov/vuln/detail/CVE-2020-25213)
WP-file-manager wordpress plugin (&lt;6.9) vulnerable to unauthenticated arbitary file upload resulting in full compromise of the system.

For More more details refer to my writeup published [here](https://medium.com/@mansoorr/exploiting-cve-2020-25213-wp-file-manager-wordpress-plugin-6-9-3f79241f0cd8)

## Disclaimer
I haven't discovered this vulnerability & neither taking any credits of this CVE. I have only created the exploit after analyzing the description available on various blogs like [wordfence](https://www.wordfence.com/blog/2020/09/700000-wordpress-users-affected-by-zero-day-vulnerability-in-file-manager-plugin/), [seravo](https://seravo.com/blog/0-day-vulnerability-in-wp-file-manager/) with the motto to let the readers understand how to create POC by just analyzing the description of the vulnerability.  
I am not responsible for any damage caused to an organization using this exploit & I would advice the readers not to exploit this vulnerability without written consent from the organization as it may expose the organization open to attacks by other hackers.

## Installation
`git clone https://github.com/mansoorr123/wp-file-manager-CVE-2020-25213.git`  
`chmod +x wp-file-manager-CVE-2020-25213/wp-file-manager-exploit.sh`

## Swtitches
```
-u|--wp_url				Wordpress target url  
-f|--upload_file			Absolute location of local file to upload on the target.  
-k|--check				Only checks whether the vulnerable endpoint exists & have particular fingerprint or not. No file is uploaded.  
-v|--verbose				Also prints curl command which is going to be executed  
-h|--help				Print Help menu  
```

## Usage  
./wp-file-manager-exploit.sh --wp_url https://www.example.com/wordpress --check  
./wp-file-manager-exploit.sh --wp_url https://wordpress.example.com/ -f /tmp/php_hello.php --verbose
 
## Snaps

![Screenshot 1](.snaps/wp-file-manager_snap_1.png)
![Screenshot 2](.snaps/wp-file-manager_snap_2.png)
![Screenshot 3](.snaps/wp-file-manager_snap_3.png)

## Credits
1. https://www.wordfence.com/blog/2020/09/700000-wordpress-users-affected-by-zero-day-vulnerability-in-file-manager-plugin/
2. https://seravo.com/blog/0-day-vulnerability-in-wp-file-manager/
