# cve-2020-23127-PoC

CVE-2020-23127:
https://www.cvedetails.com/cve/CVE-2020-23127/

## Introduction

This is my first CVE proof of concept and analysis. It was done as part of my cyber-security course on my 2nd year of Master in Computer Sciences at Université de Franche-Comté. 

I looked specifically for a CSRF CVE to better understand this kind of vulnerability and protections against CSRF attacks.

## CVE analysis

You will find a CVE analysis made by me in the .docx format. It is currently in French only.

## What is needed for the PoC

### 1) Docker

Install Docker if not already present on your machine.

### 2) Files from this repository

You need to download the following files:
- compose.yaml
- dump.sql
- dump-updated.sql

These 3 files have to be in the same directory for the docker compose command to work.

### 3) Execute the docker compose command

docker compose up -d

## Proof of concept

### 1) Open localhost:8081

### 2) Log in as admin/admin
![image](https://github.com/user-attachments/assets/b15f41a1-021d-4127-abbd-d995e35aca41)

### 3) Go to Administration > Users > List of Users
![image](https://github.com/user-attachments/assets/38d7fb03-bcaa-48ab-be09-92ec79534252)

You will notice that there is the user "Juan Hernandez" with the role Student (Apprenant)

![image](https://github.com/user-attachments/assets/d75f57c0-9030-4f5b-9f8d-f834e1b84b8a)

### 4) In another tab, open localhost:8082

By entering this website, a CSRF attack is done with a customized POST request:
http://localhost:8081/main/admin/user_edit.php?user_id=3

### 5) Go back to the tab with localhost:8081 and refresh the page

![image](https://github.com/user-attachments/assets/8192c942-c278-4de5-ad19-46033cfa8081)

You will now see that the user "Juan Hernandez" has the role Teacher (Enseignant)

