/*
 * Decompiled with CFR 0.152.
 */
package com.threedr3am.bug.tomcat.ajp.support;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.coyote.ajp.AjpMessage;
import org.apache.coyote.ajp.Constants;

public class TesterAjpMessage
extends AjpMessage {
    private final List<Header> headers = new ArrayList<Header>();
    private final Map<String, String> attribute = new LinkedHashMap<String, String>();

    public TesterAjpMessage(int packetSize) {
        super(packetSize);
    }

    public byte[] raw() {
        return this.buf;
    }

    public byte readByte() {
        return this.buf[this.pos++];
    }

    public int readInt() {
        int val = (this.buf[this.pos++] & 0xFF) << 8;
        return val += this.buf[this.pos++] & 0xFF;
    }

    public String readString() {
        int len = this.readInt();
        return this.readString(len);
    }

    public String readString(int len) {
        StringBuilder buffer = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = (char)this.buf[this.pos++];
            buffer.append(c);
        }
        this.readByte();
        return buffer.toString();
    }

    public String readHeaderName() {
        byte b = this.readByte();
        if ((b & 0xFF) == 160) {
            return Constants.getResponseHeaderForCode(this.readByte());
        }
        int len = (b & 0xFF) << 8;
        return this.readString(len += this.getByte() & 0xFF);
    }

    public void addHeader(int code, String value) {
        this.headers.add(new Header(code, value));
    }

    public void addHeader(String name, String value) {
        this.headers.add(new Header(name, value));
    }

    public void addAttribute(String name, String value) {
        this.attribute.put(name, value);
    }

    @Override
    public void end() {
        this.appendInt(this.headers.size());
        for (Header header : this.headers) {
            header.append(this);
        }
        for (Map.Entry entry : this.attribute.entrySet()) {
            this.appendByte(10);
            this.appendString((String)entry.getKey());
            this.appendString((String)entry.getValue());
        }
        this.appendByte(255);
        this.len = this.pos;
        int dLen = this.len - 4;
        this.buf[0] = 18;
        this.buf[1] = 52;
        this.buf[2] = (byte)(dLen >>> 8 & 0xFF);
        this.buf[3] = (byte)(dLen & 0xFF);
    }

    @Override
    public void reset() {
        super.reset();
        this.headers.clear();
    }

    private static class Header {
        private final int code;
        private final String name;
        private final String value;

        public Header(int code, String value) {
            this.code = code;
            this.name = null;
            this.value = value;
        }

        public Header(String name, String value) {
            this.code = 0;
            this.name = name;
            this.value = value;
        }

        public void append(TesterAjpMessage message) {
            if (this.code == 0) {
                message.appendString(this.name);
            } else {
                message.appendInt(this.code);
            }
            message.appendString(this.value);
        }
    }
}

