# CVE-2020-1350 (SIGRed) - Windows DNS DoS Exploit

Credits for the bug are entirely down to Check Point Research ([@_cpresearch\_](https://twitter.com/_cpresearch_)) who did an incredible writeup of this bug (props to [@sagitz_](https://twitter.com/sagitz_) for the post)
Their writeup can be found [here](https://research.checkpoint.com/2020/resolving-your-way-into-domain-admin-exploiting-a-17-year-old-bug-in-windows-dns-servers/).


This exploit was written by [@maxpl0it](https://twitter.com/maxpl0it)

Quick summary of how it works:
  1) On the LAN you trigger a DNS request (more specifically, a request for the SIG records) for an evil domain (for example 9.evil_domain.com)
  2) This gets sent to the vulnerable Windows server's DNS server
  3) The vulnerable server sends a request to whatever DNS it forwards requests to (usually the standard Google IPs)
  4) The Google DNS responds with the nameservers for the evil domain
  5) The vulnerable server then acts as a DNS client and sends a request to the evil DNS server
  6) The evil server responds with a payload that overflows a 2-byte number, causing a smaller allocation to take place than is required
  7) The signature is copied over and things break (of course), crashing the vulnerable server's DNS server


General Setup:
--------------
- This exploit requires you to set up a domain with its own nameservers pointing to your server.
- Set up the server and run this script. It will listen on port 53 on both TCP and UDP
- If you get an error saying that the ports are busy, use netstat -pa to figure out what's listening on the domain ports (probably systemd-resolved) and disable + stop it. If nothing's listening on the server, make sure you killed all instances of this script before re-running.

For example, I ran `python sigred_dos.py ibrokethe.net` to start the malicious DNS server


Testing Setup:
--------------
If you have access to the Windows server, you can configure a conditional forwarder to point ibrokethe.net to the IP address of the host running the script.  This effectively skips steps 3 & 4 in the summary.


Execution:
----------
In order to trigger the vulnerability on the Windows DNS server, run `nslookup -type=sig 9.your_domain_name_here dns_server_to_target`
The subdomain '9' is indeed required here. You do not have to make any domain record changes for this since the script deals with it.

As an example: I ran `nslookup -type=sig 9.ibrokethe.net 127.0.0.1` as I was running this on the server.
