# COVIDSafe-CVE-2020-12856: A silent pairing issue in bluetooth-based contact tracing apps

Authors: Jim Mussared (George Robotics), Alwen Tiu (The Australian National University)

A vulnerability has been identified in the implementation of the Android version of Australia's COVIDSafe (v1.0.17 and earlier) contact tracing app that may affect several other contact tracing apps that share a similar architecture, such as Singapore's TraceTogether and Alberta's ABTraceTogether. This issue is being tracked using the CVE ID [CVE-2020-12856](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2020-12856). 
This vulnerability allows an attacker to bond silently with an Android phone running a vulnerable version of the app. The bonding process involves exchanges of permanent identifiers of the victim phone: the identity address of the bluetooth device in the phone and a cryptographic key called Identity Resolving Key (IRK). Either one of these identifiers can be used for long term tracking of the phone.  

This vulnerability was reported to DTA (who is responsible for the COVIDSafe app) on May 5th, 2020, and it has been fixed in COVIDSafe (Android) v1.0.18. 
Details of our finding are available [here](https://github.com/alwentiu/COVIDSafe-CVE-2020-12856/blob/master/CVE-2020-12856-19-June-2020.pdf). 

The proof-of-concept code can be found [here.](https://github.com/alwentiu/COVIDSafe-CVE-2020-12856/blob/master/code)

An earlier draft (dated May 18th, 2020) that was sent to various developer teams is 
available [here.](https://github.com/alwentiu/COVIDSafe-CVE-2020-12856/blob/master/CVE-2020-12856-18-may-2020.pdf)
(Note that this earlier draft has a small typo in the CVE ID; it refers to CVE-2020-12586 instead of CVE-2020-12856)


