# CVE-2020-0674
CVE-2020-0674 is a use-after-free vulnerability in the legacy jscript engine. It can be triggered in Internet Explorer. The exploit here is written by [maxpl0it](https://twitter.com/maxpl0it) but the vulnerability itself was discovered by [Qihoo 360](http://blogs.360.cn/) being used in the wild. This exploit simply pops calc.

[Exploit writeup can be found here](https://labs.f-secure.com/blog/internet-exploiter-understanding-vulnerabilities-in-internet-explorer/).

# Vulnerability Overview
- The vulnerability exists in the Array `sort` function when using a comparator function.
- The two supplied arguments for the comparator function are not tracked by the Garbage Collector and thus will point to freed memory after the GC is called.

# Exploit Notes
- The exploit was written for Windows 7 specifically, but could probably be ported without too much hassle.
- This exploit was written for x64 instances of IE, therefore will run on (and has been tested on) the following browser configurations:
  - IE 8 (x64 build)
  - IE 9 (x64 build)
  - IE 10 (Either with Enhanced Protected Mode enabled or TabProcGrowth enabled)
  - IE 11 (Either with Enhanced Protected Mode enabled or TabProcGrowth enabled)
- It's worth noting that Enhanced Protected Mode on Windows 7 simply enables the x64 version of the browser process so it's not a sandbox escape so much as there not being any additional sandbox. Ironically since this exploit is for x64, EPM actually allows it to work.
- The exploit isn't made to entirely bypass EMET (Only a stack pivot detection bypass has really been implemented), however the final version (5.52) doesn't seem to trigger EAF+ when the exploit is run whereas 5.5 does (at least, on Windows 7 x64). So IE 11 in Enhanced Protected Mode with maximum EMET settings enabled allows the exploit.
- The exploit is heavily commented but in order to get a better understanding of how the exploit works and what it's doing at each stage, change `var debug = false;` to `var debug = true;` and either open the developer console to view the log or keep it closed and view the `alert` popups instead (which might be a little annoying).
