# CVE-2020-0665 - SID Filter Bypass

Proof of Concept for [CVE-2020-0665](https://msrc.microsoft.com/update-guide/en-US/vulnerability/CVE-2020-0665), which allows bypassing SID Filtering in Active Directory Forests (Cross Forest Attack).

## Requirements for the attack

- Target Domain Controller machine must _not_ be patched after February, 2020.
- Having previously compromised a Domain Controller trusting forest (this attack requires high privileges, as `SYSTEM` user).
- A `Two-way Transitive Trust` relationship established with the trusting forest.
- `python2.7` installed in the compromised DC, along with [frida](https://frida.re/) library (`pip2 install frida`) in the compromised DC trusting forest. P.S.: I have not tested it with `python3`, maybe it works as well?
- A Child Domain in the compromised domain and its SID, which we will call "child SID". For example, if we have compromised a domain `contoso.local` we need a child domain `child.contoso.local`.
- A Workstation in the foreign domain and its SID, which we will call "local SID". For example, if we have a foreign domain `test.local` (that has a `Two-way Transitive Trust` with our compromised domain `contoso.local`), we need a workstation like `SQL.test.local`, `DEV.test.local`, `MSSQL01.test.local`, etc. _If we use `DC` as workstation the attack will not work_.
- A process to hook. Recommended: `lsass.exe`.
- Patience: To trigger the attack, the Domain Controller must perform the `NetLogon` call `NetrGetForestTrustInformation`. _This happens every 24 hours, so have patience_.


## Usage
Pass the `child SID` and `local SID` (workstation) to the script. It uses part of [frida_intercept.py](https://github.com/dirkjanm/forest-trust-tools/blob/master/frida_intercept.py) script to intercept and hook a process by its name or PID. Remember this script has been tested with `python2.7`, but might work with `python3` as well (both requires `frida` library to be installed in the respective software):


In a shell as `nt authority/system` in a compromised `Domain Controller`, execute:
```shell
python .\CVE-2020-0665.py --process <process to hook> --child-sid <Child SID> --local-sid <local SID>
```
For example:
```shell-session
python .\CVE-2020-0665.py --child-sid S-1-5-21-3878752286-62540090-653003637 --local-sid  S-1-5-21-2327345182-1863223493-3435513819 -p lsass.exe -v
```
This will change the Workstation target SID (`S-1-5-21-2327345182-1863223493-3435513819`) by a child domain SID in our current Active Directory forest under our control (`S-1-5-21-3878752286-62540090-653003637`).

> [!WARNING]
> This will change the SID of the victim Workstation. Try to save all SID values before performing this attack to restore them later.

---

## Extras
For more information about this attack, check out [this blog](https://dirkjanm.io/active-directory-forest-trusts-part-two-trust-transitivity/) that teaches how to continue with the attack (forge a Golden Ticket through a `ExtraSid Attack`, for example).

For ethical purposes. Always be ethical (:

