# CVE-2019-9624
Authenticated RCE for Webmin 1.9.0

# Webmin 1.900 Authenticated RCE - CVE-2019-9624 Exploit

## 1. Vulnerability Description
**CVE-2019-9624** is an authenticated Remote Code Execution (RCE) vulnerability in Webmin versions up to 1.900. It allows an administrative user to execute arbitrary system commands with **root privileges** via the `shell` or `file` modules.

## 2. Technical Execution Flow

### Step 1: Authentication & Session Management
Webmin uses a custom authentication handler. For a successful automated login, the following are required:
* **Testing Cookie:** A cookie `testing=1` must be sent to satisfy Webmin's check for browser cookie support.
* **Referer Header:** The server checks the `Referer` header to prevent Cross-Site Request Forgery (CSRF). If the header doesn't match the expected CGI path, the login is rejected.
* **SID (Session ID):** On success, the server issues a `sid` cookie which acts as the bearer token for all subsequent commands.

### Step 2: Bypassing Encoding Restrictions
A major hurdle in exploiting Webmin 1.900 is its strict input parsing. Most modules expect **Multipart/Form-Data** (MIME) encoding. 
* **The Error:** If a script sends a standard URL-encoded POST, the server returns: `Expecting form-data encoding, but got normal encoding`.
* **The Fix:** The exploit must use a multipart boundary to wrap the `cmd` parameter, simulating a file upload or complex form submission.



### Step 3: Command Injection
The payload is sent to `/shell/index.cgi`. The Perl backend takes the `cmd` variable and executes it directly on the host system. By including a `pwd` parameter set to `/root`, we ensure the command executes in the context of the root user's home directory.

## 3. Exploit Components
| Component | Function |
| :--- | :--- |
| **Target URL** | Usually `http://<IP>:10000` or a proxied `/webmin` path. |
| **Payload** | Any Linux command (e.g., `id`, `whoami`, `cat /etc/shadow`). |
|
