# CVE-2019-7139 PoC: Magento SQL Injection

This repository contains a proof-of-concept (PoC) exploit for **CVE-2019-7139** (PRODSECBUG-2198), an unauthenticated SQL injection vulnerability in Magento, discovered by Charles Fol of Ambionics Security.

## Vulnerability Details
- **CVE ID**: CVE-2019-7139
- **Affected Versions**:
  - Magento Open Source <= 1.9.4.0
  - Magento Commerce <= 1.14.4.0
  - Magento 2.1 <= 2.1.16
  - Magento 2.2 <= 2.2.7
  - Magento 2.3.0
- **Description**: The vulnerability allows unauthenticated attackers to perform SQL injection via the `/catalog/product_frontend_action/synchronize` endpoint, potentially extracting sensitive data or manipulating the database.
- **Impact**: Data exposure, data manipulation, and potential escalation to further attacks.

## Purpose
This PoC is provided for **educational purposes** and **security research** only. It demonstrates how an attacker could exploit CVE-2019-7139 to extract database information using error-based or time-based SQL injection.

## Installation
1. Clone the repository:
   ```bash
   git clone https://github.com/adhammedhat111/CVE-2019-7139-PoC
   ```
2. Navigate to the repository directory:
   ```bash
   cd CVE-2019-7139-PoC
   ```
3. Install dependencies:
   ```bash
   pip install requests
   ```

## Usage
1. Run the PoC:
   ```bash
   python3 exploit.py <target_url>
   ```
2. The script will attempt to enumerate databases, tables, columns, and sample data.

## References
- [CVE-2019-7139](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2019-7139)
- [Magento Security Advisories](https://magento.com/security)
- [Ambionics Security](https://www.ambionics.io/)
- [Pentest-Tools: Exploiting SQL Injection in Magento with SQLmap](https://pentest-tools.com/blog/exploiting-sql-injection-in-magento-with-sqlmap)
- [Lexfo: Magento SQL Injection](https://blog.lexfo.fr/magento-sqli.html)

## Disclaimer
This code is for educational and research purposes only. **Do not use it against systems without explicit permission from the system owner.** The author is not responsible for any misuse or damage caused by this code. Use at your own risk.

## License
This project is licensed under the MIT License. See the LICENSE file for details.
